/*
 *
 * Database manipulation.
 *
 * (C) 1990 Vision Software
 *
 * $Id: dbase.h 1.2001 91/04/25 15:06:49 pcalvin release $
 *
 * Comments:
 *
 * With this class, we may easily save/recall organized (indexed) database
 * information.  ACCESS is used to provide us with record management
 *
 * Bugs:
 *
 * None documented
 *
 */
#if (!defined(__DATABASE__))
#define __DATABASE__

#if (!defined(__ACCESS__))
#include <access.h>
#endif

#if (!defined(__INDEX__))
#include <index.h>
#endif

/*
 *	Index file descriptors.  Used to maintain
 *	information on multiple indexes.
 */
struct ID
	{
	INDEX *pinx;						// Index object
	SZ sz;								// Key entry
	CCH cch;								// Length of key
	};
	
typedef struct ID *PID;
STATIC CONST PID pidNil = Nil;

typedef UINT CID;
STATIC CONST CID cidNil = Nil;
STATIC CONST CID cidOpenMax = 10;
STATIC CONST CID cidError = cidOpenMax+1;

/*
 *
 *	Although no information is stored by DATABASE proper, this allows us to
 * "TYPE" those structures that are to be accessed.  This will
 * (Hopefully) warn anyone maintaining code that the structure is
 * used for file access.
 *
 */
class DBASE : public INF
	{
	};

/*
 *
 * Database.  File access is controlled by ACCESS.  Indexing is used to
 * control access to specific records.
 *
 */
class DATABASE : private ACCESS
	{
public:
	DATABASE(DBASE *pdb,CCH cchRecord,SZ szFileName,BOOL fCreateFile = fFalse);
	~DATABASE();
	BOOL FSave();
	BOOL FDelete();
	BOOL FFirst();
	BOOL FLast();
	BOOL FNext();
	BOOL FPrevious();
	BOOL FCreate();
	BOOL FMark();
	BOOL FGotoMark();
	BOOL FGotoSz(SZ sz,BOOL fMatchIfClose = fFalse);
	BOOL FGotoRec(REC rec);
	BOOL FIndexTo(CID cid);
	CID CidIndexOn(SZ szFileName,CHAR *pchKey,CCH cchKey);	
	DBASE *PdbQuery();
	SZ SzIndex(CID cid = cidError);
	CCH CchIndex(CID cid = cidError);
private:
	ID rgidActive[cidOpenMax];
	PID pidCurrent;	
	CID cidAvailableMac;
	};

#endif	/* !defined(__DATABASE__) */
