/*
 *
 * Generic Field Editor
 *
 * (C) 1990 Vision Software
 *
 * $Id: edit.h 1.2001 91/04/25 15:06:48 pcalvin release $
 *
 * Comments:
 *
 * This class provides secure multi-field user input.  In addition to
 * field control, we provide services to ensure the validity of the user
 * input.
 *
 * ED is now an independent class that provides use with field manipulation
 * functions.
 *
 * Bugs:
 *
 * None documented
 *
 */
#if (!defined(__EDIT__))
#define __EDIT__

#if (!defined(__STDHDR__))
#include <stdhdr.h>
#endif

#if (!defined(__ADL__))
#include <adl.h>
#endif

#if (!defined(__FIELD__))
#include <field.h>
#endif

/*
 * Generic Edit Class Specification..
 */
class EDIT
	{
public:
	EDIT(BOOL fConfirm = fFalse,SZ sz = szNil);
	~EDIT();
	VOID Read();
	VOID Title(ROW row,COL col,SZ sz);
	VOID Field(ROW row,COL col,SZ szMsg,SZ sz,SZ szPic,SZ szHelp = szNil,SZ szDefault = szNil);
	VOID Field(ROW row,COL col,SZ szMsg,SZ sz,CHAR ch,CCH cch,SZ szHelp = szNil,SZ szDefault = szNil);
	VOID Field(ROW row,COL col,SZ szMsg,SZ sz,CCH cch,SZ szHelp,CENT cent,PENT pent,CENT centDefault = centNil);
	VOID Delimiters(CHAR chL='[',CHAR chR=']');
protected:
	VIRTUAL BOOL FHandleCd(CD cd);
	VIRTUAL BOOL FExit();
	VOID ForceNoChanges();
	BOOL FModified();
	PED PedQuery();
	VOID Rewind();
	VOID RedrawFields();
	VOID ClearFields();
	WINDOW wndEdit;
private:
	VOID NewPed(PED ped);
	BOOL FInsertNewPed(PED ped);
	HELP help;
	PED pedCurrent;
	PED pedFirst;
	PED pedLast;
	PIF pifCurrent;
	BOOL fConfirmExit;
	CHAR chLeft;
	CHAR chRight;
	SZ szTtl;
	ROW rowEditMax;
	COL colEditMax;
	};

#endif	/* !defined(__EDIT__) */
