/*
 *
 * Online-Help system.
 *
 * (C) 1990 Vision Software
 *
 * $Id: help.c 1.2002 91/05/03 14:29:23 pcalvin beta $
 *
 * Comments:
 *
 * Online quick-help system.  Bottom row may be used as direction/program
 * information
 *
 */
#include <stdhdr.h>
#include <adl.h>

#include "lowlevel.h"

/*
 *	In C++ 2.0, a Static data member is not DEFINED unless
 * it is initialized.
 */
SZ HELP::szCurrent = szNil;

/*
 * Saves previous help text..
 */
HELP::HELP(SZ sz)
	{
	szLast = szCurrent;
	szCurrent = sz;
	
	ShowCurrent();
	}

/*
 * Restores previous help text..
 */
HELP::~HELP()
	{
	szCurrent = szLast;
	
	ShowCurrent();
	}

/*
 * Initializes Global Help.  Clears bottom screen etc..
 *	szADLVersion is a macro that contains a string version
 * of the current release
 */
VOID HELP::Start()
	{
	szCurrent = szNil;
	
	ClearRow(rowGlobalWindowBottom,1,colGlobalWindowRight,coRed,coCyan);
	DisplayString(rowGlobalWindowBottom,2,"ADL v" szADLVersion " \xB3",coRed,coCyan);
	}

/*
 * Replaces the currently active QuickHelp
 */
VOID HELP::Replace(SZ sz)
	{
	if (sz != szNil)
		szCurrent = sz;

	ShowCurrent();
	}

/*
 * Update quick help at bottom of the screen
 */
VOID HELP::ShowCurrent()
	{
	CURSOR crs(fFalse);

	if (szCurrent != szNil)
		DisplayString(rowGlobalWindowBottom,14,SzTempPaddedFromSzCch(szCurrent,65),coRed,coCyan);
	}
