/*
 *
 * Private Header file for Vision WINDOWS toolkit
 *
 * (C) 1990 Vision Software
 *
 * $Id: lowlevel.h 1.2001 91/04/25 15:07:49 pcalvin release $
 *
 * Comments:
 *
 * These routines are used by our library for the lowlevel I/O
 *
 * Bugs:
 *
 * None documented
 */
#if (!defined(__LOWLEVEL__))
#define __LOWLEVEL__

#if (!defined(__MENU__))
#include <menu.h>
#endif

/*
 * Vision Propaganda Display
 */
VOID Propaganda();
VOID DosShell();
VOID TerminateApplication();

/*
 * Low-level C++ routines
 */
VOID CursorColor(CO coFore,CO coBack);
VOID HotString(ROW row,COL col,CCH cchHotKey,SZ sz,CO coFore,CO coBack);
VOID DisplayChar(ROW row,COL col,CHAR ch,CO coFore,CO coBack);
VOID DisplayString(ROW row,COL col,SZ sz,CO coFore,CO coBack);
VOID DisplayCenter(ROW row,COL colCenter,SZ sz,CO coFore,CO coBack);
VOID FillWindow(ROW row1,COL col1,ROW row2,COL col2,CHAR ch,CO coFore,CO coBack);
VOID DrawBorder(ROW row1,COL col1,ROW row2,COL col2,BD bd,CO coFore,CO coBack);
VOID SetGlobalRowCol(ROW row, COL col);

/*
 *	Private utility functions..
 */
SZ SzTempPaddedFromSzCch(SZ sz,CCH cch);
CCH CchFromCentPent(CENT cent,PENT pent);

/*
 * Inline function definitions
 */
INLINE CO
CoEgaFromCoCo(CO coFore,CO coBack)
	{
	return (((coBack & 0x7) << 4) | (coFore & 0xf));
	}

INLINE INT
Max(INT a,INT b)
	{
	return ((a > b) ? a : b);
	}

INLINE INT
Min(INT a,INT b)
	{
	return ((a < b) ? a : b);
	}

INLINE VOID
ClearColumn(ROW rowTop,COL col,ROW rowBottom,CO coFore,CO coBack)
	{
	FillWindow(rowTop,col,rowBottom,col,chSpace,coFore,coBack);
	}

INLINE VOID
ClearRow(ROW row,COL colLeft,COL colRight,CO coFore,CO coBack)
	{
	FillWindow(row,colLeft,row,colRight,chSpace,coFore,coBack);
	}

INLINE VOID
ClearWindow(ROW row1,COL col1,ROW row2,COL col2,CO coFore,CO coBack)
	{
	FillWindow(row1,col1,row2,col2,chSpace,coFore,coBack);
	}

INLINE VOID
FillColumn(ROW rowTop,COL col,ROW rowBottom,CHAR ch,CO coFore,CO coBack)
	{
	FillWindow(rowTop,col,rowBottom,col,ch,coFore,coBack);
	}

INLINE VOID
FillRow(ROW row,COL colLeft,COL colRight,CHAR ch,CO coFore,CO coBack)
	{
	FillWindow(row,colLeft,row,colRight,ch,coFore,coBack);
	}

#endif	/* !defined(__LOWLEVEL__) */
