/*
 *
 *	Public header file for menu/popup system
 *
 * (C) 1990 Vision Software
 *
 * $Id: menu.h 1.2001 91/04/25 15:06:43 pcalvin release $
 *
 * Comments:
 *
 *	We #include <dbase.h> for VSCROLL
 *
 * Bugs:
 *
 * None documented
 *
 */

#if (!defined(__MENU__))
#define __MENU__

#if (!defined(__ADL__))
#include <adl.h>
#endif

#if (!defined(__DATABASE__))
#include <dbase.h>
#endif

/*
 * Menu Entries
 */
typedef UINT CENT;					/* Count of Entries */
STATIC CONST CENT centNil = 0;
STATIC CONST CENT centError = -1;	/* Error value.. */

struct ENT
	{
	SZ sz;								/* Text for menu entry */
	CCH cchHotKey;						/* Index into Hotkey */
	VOID (*pfnFunction)();			/* Function for selected item */
	SZ szQuickHelp;					/* Text at bottom row of the screen */

	CENT centNext;						/* Number of adjacent entries */
	ENT *pentNext;						/* Poping menus to the side.. */
	};
typedef ENT *PENT;					/* Array of entries */
STATIC CONST PENT pentNil = 0;

/*
 * Menu Head
 */
struct BAR
	{
	SZ sz;							/* Text for heading */
	CCH cchHotKey;					/* Hotkey */
	CENT cent;						/* Number of entries in menu */
	PENT pent;						/* Pointer to an array of cent items */
	};
typedef BAR *PBAR;
typedef INT CBAR;
STATIC CONST CBAR cbarNil = 0;
STATIC CONST PBAR pbarNil = 0;

/*
 * Generic menus system.
 * May be used as standalone popup menus
 * Also used as a base class for Pulldowns && scrollboxes..
 */
class POPUP
	{
public:
	POPUP(ROW row,COL col,CENT cent,PENT pent,SZ sz=szNil);
	CENT CentGet();
protected:
	POPUP(SZ sz = szNil);
	CENT CentGet(ROW row,COL col,CENT cent,PENT pent);
	VIRTUAL VOID Redraw();
	VIRTUAL VOID Display(CENT cent,PENT pent,WINDOW &rwnd,BOOL fHigh);
	VIRTUAL BOOL FHandleCd(CENT &rcent,CD cd,PENT pent,WINDOW &rwnd);
	VOLATILE SZ SzFromCentPent(CENT cent,PENT pent);
	CD CdExitKey();
	CENT centMax;
	WINDOW wnd;
	HELP help;
private:
	VIRTUAL COL ColLeftFromCentPent(CENT cent,PENT pent);
	VIRTUAL ROW RowTopFromCentPent(CENT cent,PENT pent);
	VIRTUAL COL CcolFromCentPent(CENT cent,PENT pent);
	VIRTUAL ROW CrowFromCentPent(CENT cent,PENT pent);
	VOID Show();
	VOID Hide();
	VOID Flash(CENT cent,PENT pent,WINDOW &rwnd);
	BOOL FSubMenuFromCentPent(CENT cent,PENT pent);
	ROW rowTop,rowBottom;
	COL colLeft,colRight;
	ROW rowMax;
	PENT pentBase;
	CENT centAnswer;
	CD cdLastKey;
	CCH cchMenuMax;
	SZ szTitle;
	};

/*
 * Scroll boxes are simply dynamic popups..
 */
class SCROLL : public POPUP
	{
public:
	SCROLL(ROW row,COL col,CENT cent,PENT pent,CENT centView,SZ sz=szNil);
protected:
	VIRTUAL VOID Display(CENT cent,PENT pent,WINDOW &rwnd,BOOL fSelected);
	VIRTUAL ROW CrowFromCentPent(CENT cent,PENT pent);
	VIRTUAL BOOL FHandleCd(CENT &rcent,CD cd,PENT pent,WINDOW &rwnd);
	VOID KeepInView(CENT cent);
	CENT centTop;
	CENT centViewMax;
	ROW rowBase;
	};

/*
 * Virtual scroll boxes are just scroll boxes that take the entries
 * from a file..
 *	In this specific case, the scroll box entry is the index key.
 */
class VSCROLL : public SCROLL
	{
public:
	VSCROLL(ROW row,COL col,CENT centView,DATABASE &rdtb,SZ sz = szNil,CCH cch = cchNil,SZ szTitle = szNil);
protected:
	VIRTUAL VOID Redraw();
	VIRTUAL VOID Display(CENT cent,PENT pent,WINDOW &rwnd,BOOL fSelected);
	VIRTUAL COL CcolFromCentPent(CENT cent,PENT pent);
	VIRTUAL ROW CrowFromCentPent(CENT cent,PENT pent);
	VIRTUAL BOOL FHandleCd(CENT &rcent,CD cd,PENT pent,WINDOW &rwnd);
	DATABASE &rdtb;
	CCH cchIndex;
	SZ szIndex;
	};

/*
 * The pulldown system uses each menu as a special case of the
 * Popup system we just declared...
 */
class PULLDOWN : private POPUP
	{
public:
	PULLDOWN(ROW row,CBAR cbar,BAR *pbar);
	VOID ShowBar();
	CD CdGet();
private:
	VIRTUAL BOOL FHandleCd(CENT &rcent,CD cd,PENT pent,WINDOW &rwnd);
	CD CdFromAltCd(CD cd);
	ROW rowDisplay;
	SZ szHotKeys;
	COL *pcolTabs;
	CBAR cbarMax;
	BAR *pbar;
	BOOL fLeftExit;
	BOOL fRightExit;
	};

/*
 * Dialog boxes.
 */
class DIALOG : public POPUP
	{
public:
	DIALOG(SZ sz,CENT centMax,PENT pent);
	~DIALOG();
protected:
	VIRTUAL VOID Redraw();
private:
	VIRTUAL COL ColLeftFromCentPent(CENT cent,PENT pent);
	VIRTUAL ROW RowTopFromCentPent(CENT cent,PENT pent);
	VIRTUAL COL CcolFromCentPent(CENT cent,PENT pent);
	VIRTUAL ROW CrowFromCentPent(CENT cent,PENT pent);
	VIRTUAL BOOL FHandleCd(CENT &rcent,CD cd,PENT pent,WINDOW &rwnd);
	VIRTUAL VOID Display(CENT cent,PENT pent,WINDOW &rwnd,BOOL fHigh);
	CCH CchFromCentPent(CENT cent,PENT pent);
	CCH cchWidth;
	COL *pcolTabs;
	COL dcolButtons;
	SZ szLine;
	};

/*
 *	Standard menu.  Usually appears first under "System" header
 */
EXTERN ENT pentVision[];

#endif	/* !defined(__MENU__) */
