/*
 *
 * Class Implementation for Pulldown menu system
 *
 * (C) 1990 Vision Software
 *
 * $Id: pulldown.c 1.2001 91/04/25 15:07:58 pcalvin release $
 *
 * Comments:
 *
 * This class provides the traditional view of Pulldown menus.  Implementation
 * is simplified because POPUP provides most of the lower level routines
 *
 * Bugs:
 *
 *	None documented
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>

#include <stdhdr.h>
#include <adl.h>
#include <menu.h>

#include "lowlevel.h"

/*
 * Pulldown system is based upon the popup menu.
 */
PULLDOWN::PULLDOWN(ROW row,CBAR cbarTotal,PBAR pbarMenu) : POPUP(szNil)
	{
	Assert(pbarMenu != pbarNil);

	rowDisplay = row;
	cbarMax = cbarTotal;
	pbar = pbarMenu;
	pcolTabs = 0;
	szHotKeys = 0;
	}

/*
 * Show the menu bar..
 */
VOID PULLDOWN::ShowBar(VOID)
	{
	CURSOR crs(fFalse);
	CHAR cch;
	COL col;
	CBAR cbar;

	if (pcolTabs != 0)
		delete pcolTabs;

	pcolTabs = new COL[cbarMax];
	if (szHotKeys != 0)
		delete szHotKeys;

	szHotKeys = new char[cbarMax+1];

	ClearRow(rowDisplay,1,colGlobalWindowRight,coRed,coCyan);

	col = 3;
	for (cbar=0;cbar<cbarMax;cbar++)
		{
		pcolTabs[cbar] = col;
		szHotKeys[cbar] = toupper(pbar[cbar].sz[pbar[cbar].cchHotKey]);
		HotString(rowDisplay,col,pbar[cbar].cchHotKey,pbar[cbar].sz,coRed,coCyan);
		col += strlen(pbar[cbar].sz) + 2;
		}

	szHotKeys[cbarMax] = '\0';
	}

/*
 * Answers with an ASCII code for the character that was entered
 * Answers cdNil if that character is used..
 */
CD PULLDOWN::CdGet(VOID)
	{
	BOOL fContinue,fSelected;
	CD cd;
	SZ sz;
	ROW rowOriginal,crow;
	COL colOriginal,colLeft,colRight;
	PENT pentBase;
	CENT cent;
	CBAR cbar;

	Assert(pcolTabs != 0);
	Assert(szHotKeys != szNil);

	/*
	 * Make POPUP::Help point to this level
	 */
	help.Replace("Press the Alt-Key combination for the desired menu");

	/*
	 * Normalized input..
	 */
	cd = CdInput();

	if (cd < 0xff)
		return (cd);
	else
		cd = CdFromAltCd(cd);

	if (cd == cdNil || (!(sz = strchr(szHotKeys,cd))))
		return (cd);
	else
		cbar = sz - szHotKeys;

	fSelected = fFalse;
	while (!fSelected)
		{
		fLeftExit = (cbar > 0) ? fTrue : fFalse;
		fRightExit = (cbar + 1 < cbarMax) ? fTrue :fFalse;

		colLeft = pcolTabs[cbar];
		HotString(rowDisplay,colLeft,pbar[cbar].cchHotKey,pbar[cbar].sz,coBlack,coGreen);
		cent = CentGet(rowDisplay,colLeft,pbar[cbar].cent,pbar[cbar].pent);
		HotString(rowDisplay,colLeft,pbar[cbar].cchHotKey,pbar[cbar].sz,coRed,coCyan);
		/*
		 * If centains some legal value, exit, otherwise, find
		 * out which key exited.
		 */
		if (cent == centError)
			{
			switch (CdExitKey())
				{
			case cdEscape:
				return (cdNil);
			case cdCursorLeft:
				cbar -= 1;
				break;
			case cdCursorRight:
				cbar += 1;
				break;
				}
			}
		else
			{
			fSelected = fTrue;
			}
		}

	return (cdNil);
	}


/*
 * This family of methods answers CENT nil if the key should escape
 * the popup, Otherwise it returns the new CD value
 */
BOOL PULLDOWN::FHandleCd(CENT &rcent,CD cd,PENT pent,WINDOW &rwnd)
	{
	BOOL fContinue = fTrue;

	switch (cd)
		{
	case cdCursorRight:
		if (fRightExit)
			{
			fContinue = fFalse;
			rcent = centError;
			}
		break;
	case cdCursorLeft:
		if (fLeftExit)
			{
			fContinue = fFalse;
			rcent = centError;
			}
		break;
	default:
		fContinue = POPUP::FHandleCd(rcent,cd,pent,rwnd);
		break;
		}

	return (fContinue);
	}

/*
 *	Translates the input character from Alt-Alpha, into
 *	uppercase alpha.
 *	Character translation table is derived from Layout
 *	of MS-DOS keyboard.  This is obviously not-portable,
 *	similar hacking will be required for UN*X etc.
 */
CD PULLDOWN::CdFromAltCd(CD cd)
	{
	STATIC CONST CD rgcdAltTranslate[] = 
		{
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		'Q','W','E','R','T','Y','U','I','O','P',0,0,0,0,
		 'A','S','D','F','G','H','J','K','L',0,0,0,0,0,
		  'Z','X','C','V','B','N','M',0
		};

	STATIC CONST CD cdKeyMax = sizeof(rgcdAltTranslate) / sizeof(rgcdAltTranslate[0]); 
	/*
	 *	If character was Alt-Combination, translate back, otherwise
	 *	it is now Nil
	 */
	cd >>= 8;

	if (cd < cdKeyMax)
		cd = rgcdAltTranslate[cd];
	else	
		cd = cdNil;

	return (cd);
	}
