/*
 *
 *	Baseball statistic manager
 *
 * (C) 1990 Vision Software
 *
 * $Id: main.c 1.6 91/03/22 16:09:37 pcalvin beta Locker: pcalvin $
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <stdhdr.h>

#include <adl.h>
#include <menu.h>
#include <edit.h>
#include <batch.h>
#include <report.h>

#include "stats.h"

/*
 *	Macro to extract size and base from an array.  In our library,
 *	array parameters are always passed in the count,base sequence.  This
 *	macro creates that for use.  May ONLY be used on locally defined
 * arrays.
 */
#define CAndPFromRg(rg) (sizeof(rg)/sizeof(rg[0])),rg

/*
 * This static member of DATABASE controls where the class
 * looks for files.
 */
SZ ACCESS::szDataPath = "data\\";

/*
 *	Each menu is any array of ENTs.  A pulldown is created by an 
 *	array of BARs..
 */
STATIC ENT pentHitters[] = {
   { "Add/Edit/Delete Hitters",0,CreateHitters,"Edit/Create or Delete Hitters" },
	{ "Batting Champs",0,BattingChamps,"Report on Batting Champions" },
	{ "Home Run Champs",0,HomeRunChamps,"Report on Home Run Champions" },
	{ "Stolen Base Champs",0,StolenBaseChamps,"Report on Stolen Base Champions" }
	};
	
STATIC ENT pentPitchers[] = {
   { "Add/Edit/Delete Pitchers",0,CreatePitchers,"Edit/Create or Delete Pitchers" },
	{ "ERA Leaders",0,ERAChamps,"Report on Earned Run Average Leaders" },
	{ "Win Leaders",0,WinChamps,"Report on Win Leaders" },
	{ "Save Leaders",0,SaveChamps,"Report on Save Leaders" },
	{ "Strikeout Leaders",1,StrikeoutChamps,"Report on Strikeout Leaders" }
   };

STATIC BAR menu[] = {
   { "System",0,4,pentVision },
   { "Hitters",0,CAndPFromRg(pentHitters) },
   { "Pitchers",0,CAndPFromRg(pentPitchers) }
   };

/*
 *	Create Hitters Database/Index files
 */
HITTERS htrs;
DATABASE dtbHitters(&htrs,sizeof(htrs),"hitter",fTrue);
CID cidAverage = dtbHitters.CidIndexOn("average",htrs.rgchAverage,4);
CID cidHomeRun = dtbHitters.CidIndexOn("hr",htrs.rgchHomeRuns,3);
CID cidStolen = dtbHitters.CidIndexOn("sb",htrs.rgchStolen,2);
CID cidHitter = dtbHitters.CidIndexOn("hplay",htrs.rgchName,15);
CID cidHits = dtbHitters.CidIndexOn("hits",htrs.rgchHits,3);

/*
 *	Create Pitchers Database/Index files
 */
PITCHERS pchrs;
DATABASE dtbPitcher(&pchrs,sizeof(pchrs),"pitcher",fTrue);
CID cidPitcher = dtbPitcher.CidIndexOn("pplay",pchrs.rgchName,15);
CID cidERA = dtbPitcher.CidIndexOn("era",pchrs.rgchERA,5);
CID cidWins = dtbPitcher.CidIndexOn("wins",pchrs.rgchWins,2);
CID cidSaves = dtbPitcher.CidIndexOn("saves",pchrs.rgchSaves,3);
CID cidSO = dtbPitcher.CidIndexOn("so",pchrs.rgchSO,3);	

/*
 *	Main loop.  Because this is a simple menu driven program, we do 
 *	VERY little here..
 */
int main()
   {
   PULLDOWN pull(1,CAndPFromRg(menu));

   pull.ShowBar();
   
   while (fTrue)
      {
      if (pull.CdGet() == cdEscape && FAskSz("Exit System?"))
         break;
      }

   exit(0);
   }


/*
 *	By using the BATCH class, we may randomly edit the statistics of
 * of any hitter very easily.
 */
EXTERN VOID CreateHitters()
	{
	HELP help("");
	BATCH bth(dtbHitters,"Edit/Create or Delete Hitters");
	
	STATIC ENT pent[] = {
		{ "Name",0,0,"Sort edit by hitters' name" },
		{ "Average",0,0,"Sort edit by hitters' average" },
		{ "Hits",0,0,"Sort edit by number of hits" },
		{ "Home Runs",0,0,"Sort edit by number of home runs" },
		{ "Stolen Bases",0,0,"Sort edit by number of stolen bases" }
   	};

   bth.IndexSelector(1,1,"Sorted By :",CAndPFromRg(pent));

	bth.Index(2,1,cidHitter,"Player  :",'U'); 
	bth.Field(2,29,"Team :",htrs.rgchTeam,'U',3);
	bth.Index(4,5,cidAverage,"Average :",'X');
	
	bth.Field(4,23,"Games :",htrs.rgchGames,'9',3);
	bth.Field(6,5,"At Bats :",htrs.rgchAtBat,'9',3);
	bth.Field(6,23,"Runs  :",htrs.rgchRuns,'9',3);
	bth.Index(7,5,cidHits,"Hits    :",'9');
	bth.Index(7,23,cidHomeRun,"HR    :",'9');
	bth.Field(8,5,"Doubles :",htrs.rgchDoubles,'9',3);
	bth.Field(8,23,"RBIs  :",htrs.rgchRBI,'9',3);
	bth.Field(9,5,"Triples :",htrs.rgchTriples,'9',3);
	bth.Field(9,23,"Walks :",htrs.rgchWalks,'9',3);
	bth.Field(10,5,"Bases   :",htrs.rgchTotal,'9',3);
	bth.Field(10,23,"SO    :",htrs.rgchSO,'9',3);
	bth.Index(12,1,cidStolen,"Steals :",'9');
	bth.Field(12,15,"Caught :",htrs.rgchCaught,'9',2);
	bth.Field(12,29,"Errors :",htrs.rgchErrors,'9',2);

	bth.Read();
	}
	
/*
 * Editing another structure is just as easy...
 */
EXTERN VOID CreatePitchers()
	{
	HELP help("");
	BATCH bth(dtbPitcher,"Add/Edit/Delete Pitchers");
	
	STATIC ENT pent[] = {
		{ "Name",0,0,"Sort edit by pitchers' name" },
		{ "ERA",0,0,"Sort edit by pitchers ERA" },
		{ "Wins",0,0,"Sort edit by number of wins" },
		{ "Saves",0,0,"Sort edit by number of saves" },
		{ "Strike Outs",0,0,"Sort edit by number of strike outs" }
   	};

   bth.IndexSelector(1,1,"Sorted By :",CAndPFromRg(pent));

	bth.Index(2,1,cidPitcher,"Player  :",'U'); 
	bth.Field(2,29,"Team :",pchrs.rgchTeam,'U',3);
	bth.Index(4,2,cidERA,"ERA :",'X');
	
	bth.Index(4,16,cidWins,"Wins :",'9');
	bth.Field(4,28,"Loses :",pchrs.rgchLoses,'9',2);
	bth.Field(6,2,"Games    :",pchrs.rgchGames,'9',3);
	bth.Field(6,20,"Hits        :",pchrs.rgchHits,'9',3);
	bth.Field(7,2,"Complete :",pchrs.rgchComplete,'9',3);
	bth.Field(7,20,"Runs        :",pchrs.rgchRuns,'9',3);
	bth.Field(8,2,"Shutouts :",pchrs.rgchShutouts,'9',3);
	bth.Field(8,20,"Earned Runs :",pchrs.rgchEarned,'9',3);
	bth.Index(9,2,cidSaves,"Saves    :",'9');
	bth.Field(9,20,"Home Runs   :",pchrs.rgchHomeRuns,'9',3);
	bth.Field(10,2,"Innings  :",pchrs.rgchInnings,'9',3);
	bth.Index(10,20,cidSO,"SO          :",'9');
	bth.Field(11,20,"Walks       :",pchrs.rgchWalks,'9',3);

	bth.Read();
	}

/*
 *	Reports are created by selecting fields to display and (if desired) 
 *	providing a filter for the database..
 *
 *	After that, everything is taken care of by the library..
 */
EXTERN VOID HittersReport(DATABASE &rdtb,HITTERS &rhtrs,BOOL (*pfnFValid)(DBASE *pdb),BOOL fForward)
	{
	REPORT rpt(rdtb);

	rpt.SetFilterTo(pfnFValid);

	rpt.Entry(1,rhtrs.rgchName,15,"Name");
	rpt.Entry(17,rhtrs.rgchTeam,3,"For");
	rpt.Entry(21,rhtrs.rgchAverage,4," Avg");
	rpt.Entry(26,rhtrs.rgchGames,3," G");
	rpt.Entry(30,rhtrs.rgchAtBat,3," AB");
	rpt.Entry(34,rhtrs.rgchRuns,3," R");
	rpt.Entry(38,rhtrs.rgchHits,3," H");
	rpt.Entry(42,rhtrs.rgchDoubles,3," D");
	rpt.Entry(46,rhtrs.rgchTriples,3," T");
	rpt.Entry(50,rhtrs.rgchHomeRuns,3," HR");
	rpt.Entry(54,rhtrs.rgchRBI,3,"RBI");
	rpt.Entry(58,rhtrs.rgchWalks,3," W");
	rpt.Entry(62,rhtrs.rgchSO,3," SO");
	rpt.Entry(66,rhtrs.rgchStolen,2,"SB");

	rpt.Generate(fForward,FAskSz("Would you like to send report to the Printer?"));
	}

/*
 *	Again, C++ allows us to simply create reports as desired..
 */
EXTERN VOID PitchersReport(DATABASE &rdtb,PITCHERS &rpchrs,BOOL (*pfnFValid)(DBASE *pdb),BOOL fForward)
	{
	REPORT rpt(rdtb);
	
	rpt.SetFilterTo(pfnFValid);
	rpt.Entry(1,rpchrs.rgchName,15,"Name");
	rpt.Entry(17,rpchrs.rgchTeam,3,"For");
	rpt.Entry(21,rpchrs.rgchWins,2," W");
	rpt.Entry(24,rpchrs.rgchLoses,2," L");
	rpt.Entry(27,rpchrs.rgchERA,5," ERA");
	rpt.Entry(33,rpchrs.rgchGames,3," G");
	rpt.Entry(37,rpchrs.rgchShutouts,3," SO");
	rpt.Entry(41,rpchrs.rgchSaves,3," SV");
	rpt.Entry(45,rpchrs.rgchInnings,5," INN");
	rpt.Entry(51,rpchrs.rgchHits,3," H");
	rpt.Entry(55,rpchrs.rgchRuns,3," R");
	rpt.Entry(59,rpchrs.rgchEarned,3," ER");
	rpt.Entry(63,rpchrs.rgchHomeRuns,3," HR");
	rpt.Entry(67,rpchrs.rgchWalks,3," BB");
	rpt.Entry(71,rpchrs.rgchSO,3," K");

	rpt.Generate(fForward,FAskSz("Would you like to send report to the Printer?"));
	};
	
/*
 *	Filter functions used by REPORT.  In these cases, we make sure that
 *	the pitcher/batter have worked in enough games to be valid for
 *	the report.
 */
EXTERN BOOL FValidPitcher(DBASE *pdb)
	{
 	PITCHERS *ppchrs = (PITCHERS *)pdb;

 	if (atoi(ppchrs->rgchInnings) < 70)
 		return (fFalse);
	else 
		return (fTrue);
	}

EXTERN BOOL FValidBatter(DBASE *pdb)
	{
 	HITTERS *phtrs = (HITTERS *)pdb;

 	if (atoi(phtrs->rgchAtBat) < 370)
 		return (fFalse);
	else 
		return (fTrue);
	}

/* 
 *	All remaining funtions simply Select the appropriate index, and
 *	execute the report.
 */
EXTERN VOID ERAChamps()
	{
	Verify(dtbPitcher.FIndexTo(cidERA));
	
	PitchersReport(dtbPitcher,pchrs,FValidPitcher,fTrue);
	}
	
EXTERN VOID WinChamps()
	{
	Verify(dtbPitcher.FIndexTo(cidWins));

	PitchersReport(dtbPitcher,pchrs,Nil);
	}
	
EXTERN VOID SaveChamps()
	{
	Verify(dtbPitcher.FIndexTo(cidSaves));
	
	PitchersReport(dtbPitcher,pchrs,Nil);
	}
	
EXTERN VOID StrikeoutChamps()
	{
	Verify(dtbPitcher.FIndexTo(cidSO));

	PitchersReport(dtbPitcher,pchrs,Nil);
	}
	
EXTERN VOID BattingChamps()
	{
	Verify(dtbHitters.FIndexTo(cidAverage));

	HittersReport(dtbHitters,htrs,FValidBatter);
	}
	
EXTERN VOID HomeRunChamps()
	{
	Verify(dtbHitters.FIndexTo(cidHomeRun));

	HittersReport(dtbHitters,htrs,Nil);
	}
	
EXTERN VOID StolenBaseChamps()
	{
	Verify(dtbHitters.FIndexTo(cidStolen));

	HittersReport(dtbHitters,htrs,Nil);
	}
