/*
 *
 * Generic utility routines used throughout an applications
 *
 * (C) 1990 Vision Software
 *
 * $Id: utility.c 1.2003 91/05/06 14:25:03 pcalvin beta $
 *
 * Comments:
 *
 * Public utility functions.  Not specific to any class, this file contains
 * routines that may be useful to everyone (including the General Public)
 *
 * Bugs:
 *
 * None documented
 *
 */
#include <iostream.h>
#include <dos.h>
#include <string.h>

#include <stdhdr.h>

#include <adl.h>
#include <menu.h>
#include <batch.h>
#include <dbase.h>

#include "lowlevel.h"

/*
 * Company profile
 */
struct COMPANY : public DBASE
	{
	CHAR szCompany[25];
	CHAR szAddress1[25];
	CHAR szAddress2[25];
	CHAR szAddress3[25];
	CHAR szPhone[10];
	CHAR szZip[6];
	};

COMPANY cmp;
/*
 * Functions used by standard menu entry
 */
STATIC VOID EditCompany();

/*
 * Standard menu item.  Usually the first entry under the "System" title
 */
ENT pentVision[] = {
	{ "Vision Software",0,Propaganda,"Display Vision Software Company Information" },
	{ "Company Profile",0,EditCompany,"Maintain Company Profile" },
	{ "DOS Shell",0,DosShell,"Spawn a DOS Shell",},
	{ "Exit to DOS",0,TerminateApplication,"Terminate Program, Return to DOS" },
	};

/*
 * Standard Dialogs Buttons
 */
STATIC ENT pentYesNo[] = {
	{ "Yes",0,0,0 },
	{ "No",0,0,0 }
	};

/*
 * Vision Propaganda
 */
EXTERN VOID Propaganda()
	{
	STATIC CONST SZ szProceed = " Proceed ";
	WINDOW wnd(5,15,14,65,coBlack,coCyan);
	CURSOR crs(fFalse);
	HELP help(szNil);

	wnd.Open();

	wnd.SayCentered(1,"C++ Applications Development Library");
	wnd.SayCentered(3,"(C)1991 Vision Software (Canada)",coDarkGray);
	wnd.SayCentered(4,"Written by Phil Calvin",coDarkGray);
	wnd.SayCentered(5,"(416) 335-8345",coDarkGray);
	wnd.SayCentered(7,szProceed,coBlack,coGreen);

	help.Replace("Press <ENTER> to continue application");

	/*
	 * Wait specifically for the enter key
	 */
	while (CdInput() != cdReturn)
		;

	/*
	 * Simulate the flash of "Normal" popups..
	 */
	for (INT count=0; count < 5; count++)
		{
		wnd.SayCentered(7,szProceed,coBlack,coCyan);
		delay(40);
		wnd.SayCentered(7,szProceed,coBlack,coGreen);
		delay(40);
		}

	wnd.Close();
	}

/*
 * Opens a dialog, Answers with user result
 */
EXTERN BOOL FAskSz(SZ sz,SZ szHelp)
	{
	DIALOG dial(sz,2,pentYesNo);

	/*
	 * Provide QuickHelp if desired.
	 */
	pentYesNo[0].szQuickHelp = szHelp;
	pentYesNo[1].szQuickHelp = szHelp;

	return (!dial.CentGet());
	}

/*
 *	Opens a dialog.  Simple Message to user
 *
 *	NOTE: Double braces around OK are needed so compiler
 *			does not whine.
 */
EXTERN VOID SaySz(SZ sz,SZ szHelp)
	{
	STATIC ENT pent[] = { { " Ok " } };
	DIALOG dial(sz,1,pent);

	/*
	 * Place the QuickHelp..
	 */
	pent->szQuickHelp = szHelp;

	/*
	 *	No response needed..
	 */
	(VOID)dial.CentGet();
	}

/*
 *	Opens a dialog.  Error message to the user
 *
 *	NOTE: Double braces around Error are needed so compiler
 *			does not whine.
 */
EXTERN VOID ErrorSz(SZ sz,SZ szHelp)
	{
	STATIC ENT pent[] = { { " Error " } };
	DIALOG dial(sz,1,pent);

	/*
	 * Place the QuickHelp..
	 */
	pent->szQuickHelp = szHelp;

	/*
	 *	No response needed..
	 */
	(VOID)dial.CentGet();
	}
	
/*
 * Answers with a <TEMPORARY> string that is left aligned and padded
 * with spaces
 */
EXTERN SZ SzTempPaddedFromSzCch(SZ szSource,CCH cchMax)
	{
	PointerAssert(szSource);
	Assert(cchMax < cchSzTempMax);

	STATIC SZTEMP sz;
	SZ szWork = sz;

	/*
	 * Answers with a left aligned string padded with spaces.
	 */
	for (CCH cch = 0; cch < cchMax; cch++)
		{
		if (*szSource != chNil)
			*szWork++ = *szSource++;
		else
			*szWork++ = chSpace;
		}

	*szWork = chNil;

	return (sz);
	}

/* 
 *	Answers with the maximum width of the entries within
 *	the ENT
 */
EXTERN CCH CchFromCentPent(CENT centMac,PENT pentBase)
	{
	Assert(pentBase != pentNil);
	
	REGISTER PENT pent = pentBase;
	REGISTER CENT cent = centNil;
	REGISTER CCH cch = cchNil;

	/*
	 *	Loop over all..
	 */
	while (cent < centMac)
		{
		Assert(pent->sz != szNil);

		cch = Max(cch,strlen(pent->sz));

		pent++;
		cent++;
		}

	return (cch);
	}


STATIC VOID EditCompany()
	{
	DATABASE dtb(&cmp,sizeof(cmp),"company",fTrue);
	BATCH bth(dtb,"Edit Company Profile");

	bth.Field(1,1,"Company Name :",cmp.szCompany,'X',25,"Enter the company's full name");
	bth.Field(3,1,"Address      :",cmp.szAddress1,'X',25,"Enter the company's full address");
	bth.Field(4,1,"City         :",cmp.szAddress2,'X',25,"Enter the company's full address");
	bth.Field(5,1,"Province     :",cmp.szAddress3,'X',25,"Enter the company's full address");
	bth.Field(7,1,"Phone Number :",cmp.szPhone,'9',10,"Enter the company's phone number");
	bth.Field(8,1,"Postal Code  :",cmp.szZip,"U9U9U9","Enter the company's postal code");

	bth.Read();
	}
