/*
 *
 * Virtual Scroll Boxes.  Takes entries from a file..
 *
 * (C) 1990 Vision Software
 *
 * $Id: vscroll.c 1.2001 91/04/25 15:08:02 pcalvin release $
 *
 * Comments:
 *
 * This class provides selection boxes that come from DATABASEs.  As such
 * the true dimension of each box cannot be determined at compile time.
 *
 * Bugs:
 *
 *	None docuemnted
 *
 */
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>

#include <stdhdr.h>
#include <adl.h>
#include <menu.h>

#include "lowlevel.h"

/*
 * Sets up the dimensions and entries for the Virtual scroll box
 */
VSCROLL::VSCROLL(ROW row,COL col,CENT centView,DATABASE &rdtbOriginal,SZ sz,CCH cch,SZ szTitle) : SCROLL(row,col,centError,pentNil,centView,szTitle), rdtb(rdtbOriginal)
	{
	szIndex = (sz == szNil) ? rdtb.SzIndex() : sz;
	cchIndex = (cch == cchNil) ? rdtb.CchIndex() : cch;
	
	/*
	 * Start at the first record..
	 */
	if (rdtb.FFirst())
		Verify(rdtb.FMark());
	}

/*
 * Redraw.  Because virtual scroll boxes are disk-based, Redraw() from
 * popup does not function for our needs..
 */
VOID VSCROLL::Redraw(VOID)
	{
	Verify(rdtb.FGotoMark());

	CENT cent = centNil;

	/*
	 * Display over the entire window, unless we run out of records..
	 */
	do
		{
		Display(cent,pentNil,wnd,fFalse);
		}
	while (rdtb.FNext() && ++cent < centViewMax);

	Verify(rdtb.FGotoMark());
	}

/*
 * Even though PENT is never used, it must be a formal parameter so
 * that THIS display is called from POPUP..
 */
VOID VSCROLL::Display(CENT cent,PENT pent,WINDOW &rwnd,BOOL fSelect)
	{
	/*
	 * Display Index entry.  Derived classes may overide this function
	 */
	CO coBack = (fSelect) ? coGreen : coCyan;
	SZ sz = SzTempPaddedFromSzCch(szIndex,cchIndex);

	/*
	 * On screen..
	 */
	rwnd.SetRowCol(cent,0);
	rwnd.PutCh(chSpace,coBlack,coBack);
	rwnd.Say(sz,coBlack,coBack);
	rwnd.PutCh(chSpace,coBlack,coBack);
	}

BOOL VSCROLL::FHandleCd(CENT &rcent,CD cd,PENT pent,WINDOW &rwnd)
	{
	BOOL fContinue = fTrue;
	/*
	 * Defaults to no exit, must prove otherwise.
	 */
	switch (cd)
		{
	case cdReturn:
		fContinue = fFalse;
		break;
	case cdCursorUp:
		/*
		 * Erase old highlight..
		 */
		Display(rcent,pentNil,rwnd,fFalse);

		/*
		 *	Attempt move to previous.  Scroll window if necessary 
		 */
		if (rdtb.FPrevious())
			{
			Verify(rdtb.FMark());
			
			if (rcent == 0)
				rwnd.ScrollDrow(-1);
			else
				rcent--;
			}
		break;
	case cdCursorDown:

		/*
		 * Erase old..
		 */
		Display(rcent,pentNil,rwnd,fFalse);

		/*
		 *	Attempt move to next, scroll window as necessary
		 */
		if (rdtb.FNext())
			{
			Verify(rdtb.FMark());
			
			if (rcent+1 < centViewMax)
				rcent++;
			else
				rwnd.ScrollDrow(1);
			}

		break;
	default:
		fContinue = POPUP::FHandleCd(rcent,cd,pent,rwnd);
		break;
		}

	return (fContinue);
	}

ROW VSCROLL::CrowFromCentPent(CENT centMac,PENT pent)
	{
	return (centViewMax);
	}

ROW VSCROLL::CcolFromCentPent(CENT centMac,PENT pent)
	{
	return (cchIndex);
	}
