/*------------------------------------------------------------------------
 * filename - exit.c
 *
 * function(s)
 *        exit - terminates program
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C Run Time Library - Version 3.0                   |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1987,1988,1990 by Borland International    |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <stdlib.h>

extern	int		_atexitcnt;    /* count of atexit function pointers */
extern	atexit_t	_atexittbl[];  /* array of atexit function pointers */

void near _exitclean( int );

static	void	dummy(void)
{
}

void	(*_exitbuf)(void)   = dummy;
void	(*_exitfopen)(void) = dummy;
void	(*_exitopen)(void)  = dummy;

/*---------------------------------------------------------------------------*

Name		exit - terminates program

Usage		void exit(int status);

Prototype in	process.h and stdlib.h

Description	exit  terminates the  calling process.	Before exiting, all
		files are closed, buffered output (waiting to be output) is
		written, and  any registered "exit functions"  (posted with
		atexit) are called.

		status is provided for the  calling process as the the exit
		status of  the process. Typically a  value of 0 is  used to
		indicate a normal exit, and a non-zero value indicates some
		error.

Return value	exit never returns

*----------------------------------------------------------------------------*/
void	exit(int c)
{
	/* Execute "atexit" functions */
	while (_atexitcnt--)
		(*_atexittbl[_atexitcnt])();
    _exitclean( c );
}

