// HEAP.C

#include <windows.h>
#include <alloc.h>
#include <dos.h>

extern unsigned _WinAllocFlag;

#ifndef LDATA
#if defined(__LARGE__) || defined(__HUGE__) || defined(__COMPACT__)
#define LDATA 1
#else
#define LDATA 0
#endif
#endif


void *malloc(size_t size)
{
#if (LDATA)
    return(farmalloc(size));
#else
    return((void *)LocalAlloc(LMEM_FIXED, size));
#endif
}


void *realloc(void *block, size_t size)
{
#if (LDATA)
    return(farrealloc(block, size));
#else
    if(block == 0)
        return malloc(size);
    else 
        if(size == 0)
            {
            free(block);
            return 0;
            }
        else
            return((void *)LocalReAlloc((HANDLE) block, size, LMEM_MOVEABLE));
#endif
}


void *calloc(size_t nitems, size_t size)
{
#if (LDATA)
    return(farcalloc(nitems, size));
#else
    return((void *)LocalAlloc(LMEM_FIXED | LMEM_ZEROINIT, size * nitems));
#endif
}


void free(void *block)
{
#if (LDATA)
    farfree(block);
#else
    LocalFree((HANDLE)block);
#endif
}


void farfree(void far *block)
{
    HANDLE h;

    if ((h = (HANDLE) GlobalHandle (FP_SEG (block))) != 0)
        {
        GlobalUnlock (h);
        GlobalFree (h);
        }
}


void far *farrealloc(void far *block, unsigned long size)
{
    if (block == 0L)
        return farmalloc(size);
    else 
        {
        if (size == 0L)
            {
            farfree(block);
            return NULL;
            }
        else
            {
            HANDLE h;
            
            if ((h = (HANDLE) GlobalHandle(FP_SEG(block))) != 0)
                {
                GlobalUnlock(h);
                if ((h = GlobalReAlloc(h, size, GMEM_MOVEABLE | _WinAllocFlag)) != 0)
                    return GlobalLock(h);
                }
            return NULL;
            }
        }
}


void far *farmalloc( unsigned long size )
{
    HANDLE h;
    
    if ((h = GlobalAlloc(GMEM_MOVEABLE | _WinAllocFlag, size)) != 0)
        return GlobalLock(h);
    else
        return NULL;
}


void far *farcalloc(  unsigned long nitems, unsigned long size )
{
    HANDLE h;
    
    if ((h = GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT | _WinAllocFlag, size*nitems)) != 0)
        return GlobalLock(h);
    else
        return NULL;
}
