/*------------------------------------------------------------------------
 * filename - _matherr.c
 *
 * function(s)
 *        _matherr - floating-point error handling routine
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C Run Time Library - Version 3.0                   |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1987, 1990 by Borland International        |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/


#include <_math.h>
#include <math.h>
#include <stdio.h>
#include <errno.h>
#include <_math.h>
#include <_win.h>


/*-------------------------------------------------------------------------*

Name		_matherr - floating-point error handling routine

Usage		#include<math.h>
		double	 _matherr (_mexcep why,
				   char    *fun,
				   double  *arg1p,
				   double  *arg2p,
				   double  retval);


Prototype in	math.h

Description	_matherr serves as a focal  point for error handling in all
		math library functions; it  calls matherr and processes the
		return value from matherr.  _matherr should never be called
		directly by user programs.

		Whenever  an  error  occurs  in  one  of  the  math library
		routines _matherr is called with several arguments.

		_matherr does four things :
			. It  uses its arguments  to fill out  an exception
			  structure.

			. It  calls   matherr  with  e,  a  pointer  to the
			  exception  structure,  to   see  if  matherr	can
			  resolve the error.

			. It  examines	the  return  value from  matherr as
			  follows:
				If matherr  returns 0, (indicating  that it
				was not able to resolve the error) _matherr
				sets errno and prints an error message

				If  matherr  returns  non-zero, (indicating
				that  it  was  able  to  resolve the error)
				_matherr is  silent; it does not  set errno
				or print any messages.

			. It returns e->retval to the original caller. Note
			  that	matherr might  modify e->retval  to specify
			  the  value  it  wants   propagated  back  to	the
			  original caller.

		When  _matherr	sets  errno  (based  on  a  0  return  from
		matherr), it maps the kind of error that occurred (from the
		type field in the exception  structure) onto an errno value
		of either EDOM or ERANGE.

Return value	_matherr returns the value, e->retval.

*-------------------------------------------------------------------------*/
#ifdef	UNIX_matherr
char *whyS [] =
	{
	"argument domain error",
	"argument singularity ",
	"overflow range error ",
	"underflow range error",
	"total loss of significance",
	"partial loss of significance"
	};

double _matherr(_mexcep why,
		char	*fun,
		double	*arg1p,
		double	*arg2p,
		double	retval)
{
	struct	exception	e;

	e.type = why;
	e.name = fun;
	e.arg1 = (NULL == arg1p) ? 0 : *arg1p;
	e.arg2 = (NULL == arg2p) ? 0 : *arg2p;
	e.retval = retval;

	if (matherr (& e) == 0)
		{
        char errMsg[ 80 ];
		sprintf (errMsg, "%s (%8g,%8g): %s\n", fun,
						       *arg1p,
						       *arg2p,
						       whyS [why - 1]);
        _errorBox( errMsg );

		errno = ((OVERFLOW == why) || (UNDERFLOW == why)) ? ERANGE : EDOM;
		}
	return	e.retval;
}
#else
char *whyS [] =
	{
	"DOMAIN",	   /* argument domain error -- log (-1)		   */
	"SING",		   /* argument singularity	-- pow (0,-2))	   */
	"OVERFLOW",	   /* overflow range error	-- exp (1000)	   */
	"UNDERFLOW",   /* underflow range error -- exp (-1000)	   */
	"TLOSS",	   /* total loss of significance -- sin(10e70) */
	"PLOSS"		   /* partial loss of signif. -- not used	   */
	};

double	_matherr(_mexcep why,
		 char	 *fun,
		 double  *arg1p,
		 double  *arg2p,
		 double  retval)
{
	struct	exception	e;

	e.type = why;
	e.name = fun;
	e.arg1 = (NULL == arg1p) ? 0 : *arg1p;
	e.arg2 = (NULL == arg2p) ? 0 : *arg2p;
	e.retval = retval;

	if (matherr (& e) == 0)
		{
        char errMsg[ 80 ];
		sprintf (errMsg, "%s: %s error\n", fun, whyS [why - 1]);
        _errorBox( errMsg );
		errno = ((OVERFLOW == why) || (UNDERFLOW == why)) ? ERANGE : EDOM;
		}
	return	e.retval;
}
#endif
