/*------------------------------------------------------------------------
 * filename - asmrules.h
 *
 *	Rules & structures useful for in-line assembler
 *
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C Run Time Library - Version 3.0                   |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1987, 1990 by Borland International        |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/
/**/

#pragma inline

/****
#define  LPROG  (4 == sizeof (void (*) (void)))
#define  LDATA  (4 == sizeof (void *))
****/
#if defined(__LARGE__) || defined(__HUGE__) || defined(__COMPACT__)
#define LDATA 1
#else
#define LDATA 0
#endif

#if defined(__LARGE__) || defined(__HUGE__) || defined(__MEDIUM__)
#define LPROG 1
#else
#define LPROG 0
#endif

#define  W0(ea) (word ptr (ea))
#define  W1(ea) (word ptr (ea) [2])

#define  BY0(ea) (byte ptr (ea))
#define  BY1(ea) (byte ptr (ea) [1])

#define  FLOAT(ea)  (dword ptr (ea))
#define  DOUBLE(ea) (qword ptr (ea))
#define  LONGDOUBLE(ea) (tbyte ptr (ea))

#define _SimLocalCall_  asm     db      0E8h, 0, 0      /* call $       */
/*      jmp     toLocalProc                             NEVER USE "SHORT" ! */

#define  RETNEAR asm  db   0C3h

#if LDATA
#   define  LES_  LES
#   define  ES_   ES:
#   define  SS_   SS:
#   define  DPTR_(ea)  (dword ptr (ea))
#   define  dPtrSize    4
#   define  pushDS_     asm     push    DS
#   define  LDS_        LDS
#   define  popDS_      asm     pop     DS
#else
#   define  LES_  mov
#   define  ES_
#   define  SS_
#   define  DPTR_(ea)  (word ptr (ea))
#   define  dPtrSize    2
#   define  pushDS_
#   define  LDS_        mov
#   define  popDS_
#endif

#if LPROG
#   define  CPTR_(ea)  (dword ptr (ea))
#   define  EXTPROC(x)  (far ptr (x))
#   define  cPtrSize    4
#else
#   define  CPTR_(ea)  (word ptr (ea))
#   define  EXTPROC(x)  (x)
#   define  cPtrSize    2
#endif


/* And now the DOS error list.
*/
#define e_badFunction            1
#define e_fileNotFound           2
#define e_pathNotFound           3
#define e_tooManyOpen            4
#define e_accessDenied           5
#define e_badHandle              6
#define e_mcbDestroyed           7
#define e_outOfMemory            8
#define e_badBlock               9
#define e_badEnviron            10
#define e_badFormat             11
#define e_badAccess             12
#define e_badData               13
/* reserved                     14 */
#define e_badDrive              15
#define e_isCurrentDir          16
#define e_notSameDevice         17
#define e_noMoreFiles           18
#define e_readOnly              19
#define e_unknownUnit           20
#define e_notReady              21
#define e_unknownCommand        22
#define e_dataError             23
#define e_badRequestLength      24
#define e_seekError             25
#define e_unknownMedia          26
#define e_sectorNotFound        27
#define e_outOfPaper            28
#define e_writeFault            29
#define e_readFault             30
#define e_generalFault          31
#define e_sharing               32
#define e_lock                  33
#define e_diskChange            34
#define e_FCBunavailable        35
#define e_sharingOverflow       36
/* reserved                     37..49 */
#define e_networkUnsupported    50
#define e_notListening          51
#define e_dupNameOnNet          52
#define e_nameNotOnNet          53
#define e_netBusy               54
#define e_netDeviceGone         55
#define e_netCommandLimit       56
#define e_netHardError          57
#define e_wrongNetResponse      58
#define e_netError              59
#define e_remoteIncompatible    60
#define e_printQueueFull        61
#define e_printFileSpace        62
#define e_printFileDeleted      63
#define e_netNameDeleted        64
#define e_netAccessDenied       65              /* same as 5 */
#define e_netDeviceWrong        66
#define e_netNameNotFound       67              /* same as 53 */
#define e_netNameLimit          68
#define e_netBIOSlimit          69
#define e_paused                70
#define e_netRequestRefused     71
#define e_redirectionPaused     72
/* reserved                     73..79 */
#define e_fileExists            80
/* reserved                     81 */
#define e_cannotMake            82
#define e_failInt24             83
#define e_redirectionLimit      84
#define e_dupRedirection        85
#define e_password              86
#define e_parameter             87
#define e_netDevice             88

#define e_dosFinalError         88

/* Use these macros inside of a function to force an si or di save/restore */
#define SaveSI                  asm     __savesi equ si
#define SaveDI                  asm     __savedi equ di

/* Use these aliases inside of a function when
   you don't want si or di to be saved/restored */

#pragma warn -asm
asm     vsi     equ     si
asm     vdi     equ     di
#pragma warn .asm

/* Use these macros when you want to return a value in DX:AX and
   avoid a warning messages being generated.  Ex: return( MK_LONG ); */
#define MK_LONG   (long)((void _seg *)(_DX) + (void near *)(_AX))
#define MK_ULONG  (unsigned long)((void _seg *)(_DX) + (void near *)(_AX))
