/*  Basic types and constants for Tangle.   01 Aug 88.

Copyright (c) 1987,1988 by Borland International.  All rights reserved.
*/

#ifdef __USUAL_H__
#   error   "usual.h header file has been included twice"
#endif
#define __USUAL_H__ 1

#ifdef NULL
#   undef NULL
#endif
#ifdef FP_SEG
#   undef FP_SEG
#endif
#define NULL        ((void *) 0)
#define FP_OFF(fp)  ((unsigned)(fp))
#define FP_SEG(fp)  (((selector *)&(fp))[1])
#define NULLSEG(fp) (0 == ((selector *)&(fp))[1])

#define NULLMP      (0xBFFF)


/*  Avoid using enumerated types directly as space allocators: the
    size of field resulting will not be portable between compilers,
    even on the same CPU.
*/
#ifndef FALSE
    typedef enum    {FALSE, TRUE}   boolean_et;     /* the logical definition */
    typedef unsigned char           boolean;        /* the 8-bit definition ! */
#endif
#ifndef false
#   define false    FALSE
#   define true     TRUE
#endif

/*  The following is used when declaring variable-length arrays.
    Zero length is accepted, but can cause problems if defining
    arrays which are part of a union.
*/
#define VARIABLE    1

/*  Zero status is good, non-zero is an error.  See "qerrors.h" for details.
*/
typedef short           qStatus;

/*  Variables which are local to a source file should be declared
    private.  This will default to nothing for debugging, but may
    be converted to "static" when debug symbols are not needed.
*/
#define PRIVATE

/*  All dynalink entries must be "pascal huge", unless they belong to a
    library module which has no static data or constants in which case
    they are "pascal far".  They should return a status value as a
    result unless there is good cause otherwise.
*/
#define ENTRY       pascal huge         /* use this if MAYBE any static data */
#define LIBENTRY    pascal far          /* if SURE no static data or consts  */
#define SERVICE     qStatus ENTRY       /* recommended style, like OS/2      */
typedef SERVICE     ENTRYFN ();

#define LOCAL       pascal far

/*  All ENTRYs' var-parameters should be meticulously classed, pacem
    Ada.  This method is requested for all public interfaces.  LOCAL
    interfaces do not need to conform to such niceties.
*/
#define IN      const
#define INOUT
#define OUT


/*  Some following types may appear redundant.  The differences are
    for purposes of documentation, and because my experience has been
    that it reduces errors if the intent behind a variable is clearly
    set out at its point of declaration.

    When designing structures, it is important to state the exact width
    to ensure compatibility when structures are copied via file.  It is
    best to begin with the 64- or 32-bit fields, then the 16-bit, then
    the 8-bit.  This allows for data to be packed efficiently in 68k
    or other size-aligned architectures.
*/
typedef signed char     int8;       /* used as true integers    */
typedef signed short    int16;
typedef signed long     int32;
typedef struct
{
    int32      x [2];
}
        int64;          /* 80x87 full integer       */

typedef unsigned short  selector;   /* 80286 segment selector   */

typedef unsigned char   ord8;       /* used for ordinals        */
typedef unsigned short  ord16;
typedef unsigned long   ord32;

typedef unsigned char   card8;      /* used to count things     */
typedef unsigned long   card32;
typedef unsigned short  card16;

typedef unsigned char   bits8;      /* raw unknown bytes or bitsets */
typedef unsigned long   bits32;
typedef unsigned short  bits16;

typedef long double     real80;

typedef unsigned char   ascii;      /* used for true text           */
typedef unsigned char   asciiz;     /* text where 0 is a terminator */
typedef struct
{
    card8   len;
    ascii   s [VARIABLE];
}
    lascii;
typedef lascii          lasciiz;    /* lascii with extra 0 appended */

#define LASCII(field,count)  lascii  field;  ascii   _ascii_ [count]
#define LASCIIZ(field,count) lasciiz field;  ascii   _asciiz_ [count]

#if 0
/*
    Memory management.
*/
typedef unsigned short  masterPtr;
typedef masterPtr      *memHandle;
/*
    Locate a moveable object.
*/
#define LOCATE(seg,handle)  (seg = *(handle))
/*
    Make accessible and locate a swappable object.

    Note: swappable memory not yet implemented, same as moveable for now.
*/
#define ACCESS(seg,handle)  (seg = *handle)
#endif

#define MK_FP(seg,ofs)	((void far *) \
			   (((unsigned long)(seg) << 16) | (unsigned)(ofs)))

