/*-----------------------------------------------------------------------*
 * filename - locale.c
 *
 * function(s)
 *        setlocale  - set the locale specific info
 *        localeconv - gets the locale specific info
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C Run Time Library - Version 3.0                   |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1987,1988,1990 by Borland International    |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <locale.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>

static struct lconv locale =
  {
  ".",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  CHAR_MAX,
  CHAR_MAX,
  CHAR_MAX,
  CHAR_MAX,
  CHAR_MAX,
  CHAR_MAX,
  CHAR_MAX,
  CHAR_MAX
  };

/* At the present time we support only the C locale */
#pragma argsused
char *setlocale( int category, const char *locale )
  {
  if( locale == NULL )
    {
    return( "C" );
    }
  else
    {
    return( *locale && strcmp( locale, "C" ) ? NULL : (char *) locale );
    }
  }


struct lconv *localeconv( void )
  {
  return( &locale );
  }

