/*-----------------------------------------------------------------------*
 * filename - setenvp2.c   Prepare Program arguments vectors
 *
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C Run Time Library - Version 3.0                   |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1987,1988,1990 by Borland International    |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#ifdef   __OS2__
#include <mem.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

extern int _envLng;		/* Environment length (in startup) */
extern int _envseg;		/* Environment segment(in startup) */
extern int _envSize;		/* # of strings in Environment	   */

#define	EXTRA	4		/* # of extra envp slots to include*/

void _setenvp(void)
{
	int	i;
	char	*evBlock;

	/*
	  Get block to hold strings, copy the strings to the local block.
	  Get a block to hold the envp array pointers.	We'll get a 
	  block large enough to hold 4 more pointers than there currently
	  are.  This way minor additions can be made to the environment
	  without having to realloc the pointer array each time.
	  Fill in array of pointers with the addresses of the strings.
	  Make _envSize reflect how many slots there are now.
	*/
	if ((evBlock = malloc(_envLng)) == NULL)
		abort();
	movedata(_envseg, 0, 
		FP_SEG((char far *)evBlock), FP_OFF((char far *)evBlock),
		_envLng
		);
	if ((environ = (char **)calloc(_envSize+EXTRA,sizeof(char *))) == NULL)
		abort();
	for (i=0; i<_envSize; i++, evBlock+=(strlen(evBlock)+1))
		environ[i] = evBlock;
	_envSize += EXTRA;
}
#endif
