/*-----------------------------------------------------------------------*
 * filename - setmode.c
 *
 * function(s)
 *        setmode - sets mode of open file
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C Run Time Library - Version 3.0                   |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1987,1988,1990 by Borland International    |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/


#pragma inline
#include <io.h>
#include <asmrules.h>
#include <_io.h>
#include <fcntl.h>

/*--------------------------------------------------------------------------*

Name		setmode - sets mode of open file

Usage		int setmode(int handle, int mode);

Prototype in	io.h

Description	setmode  sets the  mode of  the open  file associated  with
		handle	to either  binary or  text. The  argument mode must
		have a value of either O_BINARY or O_TEXT, never both.

Return value	setmode returns 0 if successful; on error it returns -1 and
		sets errno to
			EINVAL	Invalid argument

*---------------------------------------------------------------------------*/
int setmode(int fildes, register int mode)
{
	register int newmode;

	if (fildes < 0 || fildes >= HANDLE_MAX || _openfd [fildes] == ~0U)
                return(__IOerror (e_badHandle));
	if ((newmode = mode & (O_TEXT | O_BINARY)) == mode &&
		newmode != (int)(O_TEXT | O_BINARY))
	{
		mode = _openfd [fildes];
		_openfd [fildes] = (mode & ~(O_TEXT | O_BINARY)) | newmode;

                return((mode & (O_TEXT | O_BINARY)));
	}
	else
                return((__IOerror (e_badFunction)));
}
