/*-----------------------------------------------------------------------*
 * filename - strtok.c
 *
 * function(s)
 *        strtok - searches one string for tokens, which are
 *                 separated by delimiters defined in a second string
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C Run Time Library - Version 3.0                   |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1987,1988,1990 by Borland International    |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <string.h>

static	char *Ss;

/*---------------------------------------------------------------------*

Name            strtok - searches one string for tokens, which are
                         separated by delimiters defined in a second string

Usage           char *strtok(char *str1, const char *str2);

Prototype in    string.h

Description	strtok considers the string str1 to consist of a sequence of
		zero or more text tokens, separated by spans of one or more
		characters from the separator string str2.

		The first call to strtok returns a pointer to the first
		character of the first token in str1 and writes a null character
		into str1 immediately following the returned token. Subsequent
		calls with NULL for the first argument will work through the
		string str1 in this way until no tokens remain.

		The separator string, str2, may be different from call to
		call.

Return value	pointer to the scanned token.  When no tokens remain in str1,
		strtok returns a NULL pointer.

*---------------------------------------------------------------------*/
#if defined(__FARFUNCS__) && defined(__LARGE__)
#include <_farfunc.h>
#endif

char *strtok(char *s1, const char *s2)
{
	register const char *sp;
	char *tok;

	if (s1) Ss = (char *)s1;

	/* First skip separators */

	while (*Ss)
	{
		for (sp = s2; *sp; sp++)
			if (*sp == *Ss)
				break;
		if (*sp == 0)
			break;
		Ss++;
	}
	if (*Ss == 0)
		return (0);
	tok = Ss;
	while (*Ss)
	{
		for (sp = s2; *sp; sp++)
			if (*sp == *Ss)
			{
				*Ss++ = 0;
				return (tok);
			}
		Ss++;
	}
	return (tok);
}
