/*-----------------------------------------------------------------------*
 * filename - tmpnam.c
 *
 * function(s)
 *        __mkname - builds a file name of the form TMPXXXXX.$$$
 *        tmpnam   - builds a unique file name
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C Run Time Library - Version 3.0                   |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1987,1988,1990 by Borland International    |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <stdio.h>
#include <_stdio.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>

static  char    template[L_tmpnam];
unsigned int    _tmpnum;

/*---------------------------------------------------------------------*

Name            __mkname - builds a file name of the form TMPXXXXX.$$$

Usage           char * pascal __mkname(char *s, unsigned num);

Prototype in    _stdio.h

Return value    a file name of the form TMPXXXXX.$$$

*---------------------------------------------------------------------*/
char * pascal near __mkname(char *s, unsigned num)
{
/*      If no buffer provided, use internal template
*/
        if (s == NULL)
                s = template;

/*      A temporary name is build as follows: TMPXXXXX.$$$
*/
        *s = '\0';
        strcat(s, "TMP");
        ultoa((unsigned long)num, s + 3, 10);
        strcat(s, ".$$$");

        return (s);
}



/*---------------------------------------------------------------------*

Name            tmpnam - builds a unique file name

Usage           char *tmpnam(char *s);

Prototype in    stdio.h

Return value    a unique temporary file name

*---------------------------------------------------------------------*/
char *tmpnam(char *s)
{
        do
		s = __mkname(s, _tmpnum += (_tmpnum == -1U) ? 2 : 1);
        while (access(s, 0) != -1);

        return (s);
}
