/*-----------------------------------------------------------------------*
 * filename - umask.c
 *
 * function(s)
 *	  umask - set file read/write permission mask
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C Run Time Library - Version 3.0                   |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1987,1988,1990 by Borland International    |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <io.h>

extern	unsigned _notUmask;

/*---------------------------------------------------------------------*

Name		umask - set file read/write permission mask

Usage		#include <io.h>
		unsigned  umask(unsigned modeMask)

Prototype in	io.h

Description	Changes the read/write permission mask used for "open"
		and "creat" calls.

Return value	The replaced value of the umask.  There is no error return.

Note		"umask" is stored internally in inverted form, for convenience.

*---------------------------------------------------------------------*/
unsigned  umask(unsigned modeMask)
{
	register    oldMask;

	oldMask = ~_notUmask;
	_notUmask = ~modeMask;
	return (oldMask);
}
