/*-----------------------------------------------------------------------*
 * filename - cplx1.cpp
 * C++ Complex Library Routines
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C++ Run Time Library - Version 1.0                 |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1990 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#pragma inline

#define RETURN_TOS	;\
	long double x_tos;		;\
	asm	fstp	tbyte ptr x_tos	;\
		return x_tos;

#include <complex.h>
#include "asmrules.h"

#define REAL	qword ptr
#define REAL1	dword ptr
#define REAL2	qword ptr
#define REAL3	tbyte ptr

#define LONG	dword ptr
#define WORD	word ptr
#define BYTE	byte ptr


double _Cdecl abs(complex& z)
{
asm	LES_	bx, z
asm	fld	REAL ES_ [bx]
asm	fmul	st(0), st(0)
asm	fld	REAL ES_ [bx+8]
asm	fmul	st(0), st(0)
asm	fadd
asm	fsqrt
	RETURN_TOS;
}

double _Cdecl norm(complex& z)
{
/*
	return z.re*z.re + z.im*z.im;
*/
asm	LES_	bx, z
asm	fld	REAL ES_ [bx]
asm	fmul	st(0), st(0)
asm	fld	REAL ES_ [bx+8]
asm	fmul	st(0), st(0)
asm	fadd
	RETURN_TOS;
}

complex& _Cdecl complex::operator*=(complex& z2)
{
/*
	return complex(z1.re*z2.re - z1.im*z2.im, z1.im*z2.re + z1.re*z2.im);
*/
asm	LES_	bx, z2
asm	fld	REAL ES_ [bx+8]
asm	fld	st(0)
asm	fld	REAL ES_ [bx]
asm	fld	st(0)

asm	LES_	bx, this
asm	fmul	REAL ES_ [bx+8]
asm	fxch	st(1)
asm	fmul	REAL ES_ [bx]

asm	fxch	st(2)
asm	fmul	REAL ES_ [bx]
asm	fxch	st(3)
asm	fmul	REAL ES_ [bx+8]
asm	fsubp	st(2), st(0)
asm	faddp	st(2), st(0)

asm	fstp	REAL ES_ [bx]
asm	fstp	REAL ES_ [bx+8]

	return *this;
}

complex _Cdecl operator*(complex& z1, complex& z2)
{
	return complex(z1.re*z2.re - z1.im*z2.im, z1.im*z2.re + z1.re*z2.im);
}
