/*-----------------------------------------------------------------------*
 * filename - filebuf.cpp
 * C++ stream I/O functions for handling filebufs
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C++ Run Time Library - Version 1.0                 |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1990 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <io.h>
#include <fcntl.h>
#include <stream.h>

// tie to existing stdio file
_Cdecl filebuf::filebuf( FILE *f )
{
    if( f ) {
	file = f;
	isopen = 1;
	fd = f->fd;
    }
    else {
	isopen = 0;
	fd = 0;
    }
}


// given a file descriptor, convert to stdio FILE
static FILE * _Cdecl fd_to_file( int fd )
{
    char *mode;
    switch( _openfd[fd] & (O_RDONLY | O_WRONLY | O_RDWR) ) {
	case O_RDONLY:
	    mode = "r";
	    break;
	case O_RDWR: 
	case O_WRONLY:
	    if( _openfd[fd] & O_APPEND ) mode = "a";
	    else mode = "w";
	    break;
	default:
	    mode = 0;	// error
	    break;
    }
    return mode ? fdopen(fd, mode) : 0;
}


// tie to existing file
_Cdecl filebuf::filebuf( int nfd )
{
    isopen = 0;
    fd = 0;
    file =  fd_to_file(nfd);
    if( file ) {
	isopen = 1;
	fd = nfd;
    }
}


// tie to file, user buffer
_Cdecl filebuf::filebuf( int nfd, char *buf, int size )
{
    isopen = 0;
    fd = 0;
    file =  fd_to_file(nfd);
    if( file ) {
	isopen = 1;
	fd = nfd;
	(void) ::setvbuf(file, buf, _IOFBF, size);
    }
}


// open a file
filebuf * _Cdecl filebuf::open( char *name, int om )
{
    char *mode = 0;

    switch( om ) {
	case input: mode = "r"; break;
	case output: mode = "w"; break;
	case append: mode = "a"; break;
	default: break;	// error
    }
    if( mode ) {
	file = fopen(name, mode);
	if( file ) {
	    fd = file->fd;
	    return this;
	}
    }
    return 0;
}


// close a file
int _Cdecl filebuf::close()
{
    int ret;

    if( file ) {
	ret = fclose(file);
	file = 0;
    }
    else ret = ::close(fd);
    isopen = 0;

    return ret;
}


// overflow and underflow do not get called, since Standard I/O is used.
