/*-----------------------------------------------------------------------*
 * filename - format.cpp
 * C++ output conversion functions
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C++ Run Time Library - Version 1.0                 |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1990 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <string.h>
#include <stdarg.h>
#include <stream.h>

#define SIZE BUFSIZ		// circular buffer size
static char buf[SIZE];		// circular buffer
static char *bufp = buf;	// next available location in buf


// common conversion for dec, hex, oct
static char * _Cdecl conv( char *fmt, long val, int width )
{
    if( bufp + (width ? width : 12) >= buf + (SIZE-1) )
	bufp = buf;
    char *ret = bufp;
    *bufp = 0;
    if( width == 0 )
	bufp += sprintf(bufp, fmt, val);
    else if( width > 11 ) {
	char *p = new char[ width+1 ];
	if( p != 0 ) {
	    (void) sprintf(p, fmt, val);
	    bufp += sprintf(bufp, "%*.*s", width, width, p);
	    delete p;
	}
    }
    else {
	char p[12];
	(void) sprintf(p, fmt, val);
	bufp += sprintf(bufp, "%*.*s", width, width, p);
    }
    bufp++;
    return ret;
}


// internal to decimal text
char * _Cdecl dec( long val, int width )
{
    return conv("%ld", val, width);
}


// internal to hex text
char * _Cdecl hex( long val, int width )
{
    return conv("%lx", val, width);
}


// internal to octal text
char * _Cdecl oct( long val, int width )
{
    return conv("%lo", val, width);
}


// char to string
char * _Cdecl chr( int c, int width )
{
    if( width == 0 ) width = 1;
    if( (bufp + width) >= (buf + SIZE - 1) )
	bufp = buf;
    char *ret = bufp;
    while( --width > 0 )
	*bufp++ = ' ';
    *bufp++ = c;
    *bufp++ = 0;
    return ret;
}

// make fixed-width string
char * _Cdecl str( const char *s, int width )
{
    if( width == 0 ) width = strlen((char *)s);
    if( (bufp + width) >= (buf + SIZE - 1) )
	bufp = buf;
    char *ret = bufp;
    *bufp = 0;
    bufp += sprintf(bufp, "%*.*s", width, width, s) + 1;
    return ret;
}


// general formating
char * _Cdecl form( char *format ... )
{
    va_list ap;
    if( bufp >= (buf + SIZE/2) )	// ensure 1/2 buffer is left
	bufp = buf;
    char *ret = bufp;
    *bufp = 0;
    va_start(ap, format);
    bufp += vsprintf(bufp, format, ap) + 1;
    va_end(ap);
    return ret;
}
