/*-----------------------------------------------------------------------*
 * filename - istream.cpp
 * C++ stream I/O functions for handling istreams, except floating-point
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C++ Run Time Library - Version 1.0                 |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1990 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <ctype.h>
#include <stdlib.h>
#include <stream.h>


// connect to streambuf or filebuf
_Cdecl istream::istream( streambuf *s, int skip, ostream *t )
{
    stream = s;
    tied_to = t;
    skipping = skip;
    mystream = 0;
    state = s ? _good : _fail;
}


// connect to string
_Cdecl istream::istream( int size, char *buf, int skip)
{
    stream = new streambuf;
    if( stream ) {
	stream->setbuf(buf, size, size);
	state = _good;
	mystream = 1;
	skipping = skip;
	tied_to = 0;
    }
    else {
	state = _fail;
	mystream = 0;
    }
}


// connect to open file
_Cdecl istream::istream( int nfd, int skip, ostream *t)
{
    mystream = 0;
    state = _fail;

    stream = new filebuf(nfd);
    if( stream ) {
	if( stream->file ) {
	    mystream = 1;
	    skipping = skip;
	    state = _good;
	    tied_to = t;
	}
    }
}



/*
 * input functions
 */
istream& _Cdecl istream::operator >> ( unsigned char& c )
{
    if( state == _good ) {
	int i;
	do {
	    i = stream->snextc();
	} while( skipping && isspace(i) );
	if( i == EOF ) {
	    state = _eof;
	    if( stream->file )
		if( ferror(stream->file) )
		    state = _fail;
	}
	else
	    c = i;
    }
    return *this;
}


/* skip whitespace if required, verify stream status
   return status (ok), and character found, if any
*/
void _Cdecl istream::checkskip( int& ok, int& c )
{
    ok = 0;		// assume the worst
    int i = 0;
    if( state == _good ) {
	do {
	    i = stream->snextc();
	} while( skipping && isspace(i) );
	if( i == EOF ) {
	    state = _eof;
	    if( stream->file )
		if( ferror(stream->file) )
		    state = _fail;
	}
    }
    if( state == _good ) {
	if ( skipping || ! isspace(i) )
	    ok = 1;		// no whitespace, or was allowed
	else {
	    putback(i);		// disallowed whitespace found
	    state = _fail;
	}
    }
    c = i;
}


long _Cdecl istream::get_long( int isunsigned )
{
    long l = 0;
    int ok, c;

    checkskip(ok, c);
    if( ok ) {
	putback(c);
	if( stream->file ) {
	    if( fscanf(stream->file, isunsigned ? "%lu" : "%ld", &l) != 1 )
		state = _fail;
	}
	else {
	    char *ogptr = stream->gptr;
	    if (isunsigned)
		l = (long) strtoul(stream->gptr, &(stream->gptr), 10);
	    else
		l = strtol(stream->gptr, &(stream->gptr), 10);
	    if( ogptr == stream->gptr )
		state = _fail;
	}
    }
    return l;
}


istream& _Cdecl istream::operator >> ( char *s )
{
    int ok, i;

    checkskip(ok, i);
    if( ok ) {
	do {
	    *s++ = (char) i;
	    i = stream->snextc();
	} while( (i != EOF) && (! isspace(i)) );
	if( i == EOF ) {
	    state = _eof;
	    if( stream->file )
		if( ferror(stream->file) )
		    state = _fail;
	}
	else putback(i);
	*s = 0;
    }
    return *this;
}

#pragma argsused
istream& _Cdecl istream::operator >> ( whitespace& w )
{
    if( state == _good ) {
	int i;
	do {
	    i = stream->snextc();
	} while( isspace(i) );
	if( i == EOF ) {
	    state = _eof;
	    if( stream->file )
		if( ferror(stream->file) )
		    state = _fail;
	}
	else putback((char) i);
    }
    return *this;
}


istream& _Cdecl istream::get(char& c)
{
    if( state == _good ) {
	int i = stream->snextc();
	if( i == EOF ) {
	    state = _eof;
	    if( stream->file )
		if( ferror(stream->file) )
		    state = _fail;
	}
	else
	    c = (char) i;
    }
    return *this;
}


istream& _Cdecl istream::get(char *buf, int max, int term)
{
    if( state == _good ) {
	if( max > 0 ) {
	    int i = stream->snextc();
	    while( max > 0  &&  i != EOF  &&  i != term ) {
		*buf = (char) i;
		--max;
		++buf;
		i = stream->snextc();
	    }
	    if( i == EOF ) {
		state = _eof;
		if( stream->file )
		    if( ferror(stream->file) )
			state = _fail;
	    }
	    else putback(i);
	}
	*buf = 0;
    }
    return *this;
}
