/*-----------------------------------------------------------------------*
 * filename - istrf.cpp
 * C++ floating-point stream I/O functions for handling istreams
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C++ Run Time Library - Version 1.0                 |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1990 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <ctype.h>
#include <stdlib.h>
#include <stream.h>


istream& _Cdecl istream::operator >> ( float& f )
{
    int ok, c;
    checkskip(ok, c);
    if( ok ) {
	putback(c);
	if( stream->file ) {
	    if( fscanf(stream->file, "%f", &f) != 1 )
		state = _fail;
	}
	else {
	    char *ogptr = stream->gptr;
	    double t = strtod(stream->gptr, &(stream->gptr));
	    if( ogptr == stream->gptr )
		state = _fail;	// no conversion
	    else {
		f = t;
		if( stream->gptr > stream->eptr )
		    stream->gptr = stream->eptr;
	    }
	}
    }
    return *this;
}


istream& _Cdecl istream::operator >> ( double& d )
{
    int ok, c;
    checkskip(ok, c);
    if( ok ) {
	putback(c);
	if( stream->file ) {
	    if( fscanf(stream->file, "%lf", &d) != 1 )
		state = _fail;
	}
	else {
	    char *ogptr = stream->gptr;
	    double t = strtod(stream->gptr, &(stream->gptr));
	    if( ogptr == stream->gptr )
		state = _fail;	// no conversion
	    else {
		d = t;
		if( stream->gptr > stream->eptr )
		    stream->gptr = stream->eptr;
	    }
	}
    }
    return *this;
}


istream& _Cdecl istream::operator >> ( long double& d )
{
    int ok, c;
    checkskip(ok, c);	// scans off whitespace
    if( ok ) {
	putback(c);
	if( stream->file ) {
	    if( fscanf(stream->file, "%Lf", &d) != 1 )
		state = _fail;
	}
	else {
	    char *p = stream->gptr;
	    // too bad we don't have a strtoLd function
	    if( sscanf(p, "%Lf", &d) != 1 )
		state = _fail;
	    else {
		// skip past the value read
		if( *p == '+' || *p == '-' )
		    ++p;
		while( isdigit(*p) )
		    ++p;
		if( *p == '.' ) {
		    ++p;
		    while( isdigit(*p) )
			++p;
		}
		if( *p == 'e' || *p == 'E' ) {
		    ++p;
		    if( *p == '+' || *p == '-' )
			++p;
		    while( isdigit(*p) )
			++p;
		}
		stream->gptr = (p > stream->eptr) ? stream->eptr : p;
	    }
	}
    }
    return *this;
}
