/*-----------------------------------------------------------------------*
 * filename - manip.cpp
 * Predefined manipulators
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C++ Run Time Library - Version 1.0                 |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1990 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <iostream.h>
#include <iomanip.h>


// set the conversion base to 0, 8, 10, or 16
static ios& sbase(ios& i, int b)
{
    long l = 0;
    if( b == 16 ) l = ios::hex;
    else if (b == 10) l = ios::dec;
    else if( b == 8 ) l = ios::oct;
    i.setf(l, ios::basefield);
    return i;
}
smanip_int setbase(int b)
{
    return smanip_int(sbase, b);
}


// clear the flags bitvector according to the bits set in b
static ios& rsios(ios& i, long b)
{
    i.unsetf(b);
    return i;
}
smanip_long resetiosflags(long b)
{
    return smanip_long(rsios, b);
}


// set the flags bitvector according to the bits set in b
static ios& sios(ios& i, long b)
{
    i.setf(b);
    return i;
}
smanip_long setiosflags(long b)
{
    return smanip_long(sios, b);
}


// set fill character for padding a field
static ios& sfill(ios& i, int f)
{
    i.fill(f);
    return i;
}
smanip_int setfill(int f)
{
    return smanip_int(sfill, f);
}


// set the floating-point precision to n digits
static ios& sprec(ios& i, int n)
{
    i.precision(n);
    return i;
}
smanip_int setprecision(int n)
{
    return smanip_int(sprec, n);
}


// set the field width to n
static ios& swidth(ios& i, int n)
{
    i.width(n);
    return i;
}
smanip_int setw(int n)
{
    return smanip_int(swidth, n);
}
