/*-----------------------------------------------------------------------*
 * filename - ostream.cpp
 * C++ stream I/O functions for handling ostreams, except floating-point
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C++ Run Time Library - Version 1.0                 |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1990 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <stdlib.h>
#include <stream.h>


// connect to existing streambuf
_Cdecl ostream::ostream( streambuf *s )
{
    stream = s;
    mystream = 0;
    state = s ? _good : _fail;
}


// constructor: connect to open file
_Cdecl ostream::ostream( int nfd )
{
    mystream = 0;
    state = _fail;

    stream = new filebuf(nfd);
    if( stream ) {
	if( stream->file ) {
	    mystream = 1;
	    state = _good;
	}
    }
}


// connect to char array
_Cdecl ostream::ostream( int size, char *buf )
{
    mystream = 0;
    state = _fail;

    if( buf ) {
	stream = new streambuf(buf, size);
	state = _good;
    }
    else {
	stream = new streambuf();
	if( stream ) {
	    stream->allocate();
	    mystream = 1;
	    state = _good;
	}
    }
}


// flush output buffer
ostream& _Cdecl ostream::flush()
{
    if( state < _fail )
	if( stream->file )
	    (void) fflush(stream->file);
	else
	    (void) stream->overflow();
    return *this;
}


// write a char, short, or int
ostream& _Cdecl ostream::operator << ( int i )
{
    char b[8];
    if( state < _fail) {
	itoa(i, b, 10);
	register char *p = b;
	while( *p )
	    put(*p++);
    }
    return *this;
}


// write a long
ostream& _Cdecl ostream::operator << ( long l )
{
    char b[12];
    if( state < _fail) {
	ltoa(l, b, 10);
	register char *p = b;
	while( *p )
	    put(*p++);
    }
    return *this;
}


// write an unsigned long
ostream& _Cdecl ostream::operator << ( unsigned long l )
{
    char b[12];
    if( state < _fail) {
	ultoa(l, b, 10);
	register char *p = b;
	while( *p )
	    put(*p++);
    }
    return *this;
}

// write a string
ostream& _Cdecl ostream::operator << ( const char * s )
{
    if( state < _fail) {
	while( *s ) put(*s++);
	stream->terminate();
    }
    return *this;
}
