/*-----------------------------------------------------------------------*
 * filename - ostrf.cpp
 * C++ stream floating-point I/O functions for handling ostreams
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C++ Run Time Library - Version 1.0                 |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1990 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <stream.h>


// write floating-point
ostream& _Cdecl ostream::operator << ( double d )
{
    char b[64];
    if( state < _fail ) {
	register int count = sprintf(b, "%g", d);
	register char *p = b;
	while( count-- )
	    put(*p++);
    }
    return *this;
}


// write floating-point
ostream& _Cdecl ostream::operator << ( long double d )
{
    char b[64];
    if( state < _fail ) {
	register int count = sprintf(b, "%Lg", d);
	register char *p = b;
	while( count-- )
	    put(*p++);
    }
    return *this;
}
