/*-----------------------------------------------------------------------*
 * filename - streambf.cpp
 * C++ stream I/O functions for handling streambufs
 *-----------------------------------------------------------------------*/

/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     Turbo C++ Run Time Library - Version 1.0                 |*/
/*|                                                              |*/
/*|                                                              |*/
/*|     Copyright (c) 1990 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

#include <stream.h>


// destructor (virtual)
_Cdecl streambuf::~streambuf()
{
    if( didalloc ) {
	delete base;
	didalloc = 0;
    }
}


// default overflow: do nothing
#pragma argsused
int _Cdecl streambuf::overflow( int c)
{
    return EOF;
}


// default underflow: do nothing
int _Cdecl streambuf::underflow()
{
    return EOF;
}


// allocate a standard size buffer
int _Cdecl streambuf::allocate()
{
    int ret = 0;
    if( ! didalloc ) {		// no action if we did a previous alloc
	char *p = new char[BUFSIZ];

	if( p == 0 ) ret = EOF;	// no change if we can't allocate space
	else {
	    pptr = p;
	    gptr = p;
	    base = p;
	    eptr = p + BUFSIZ;
	    didalloc = 1;
	}
    }
    return ret;
}


// specify a buffer to use, possibly with data in it (offset > 0 )
streambuf * _Cdecl streambuf::setbuf( char *buf, int len, unsigned offset )
{
    if( didalloc ) {
	delete base;
	didalloc = 0;
    }
    base = buf;
    gptr = buf;
    pptr = buf + (offset < len ? offset : len );
    eptr = buf + len;
    return this;
}


// return a char to input buffer
void _Cdecl streambuf::sputbackc( char c )
{
    if( c != EOF )
	if( gptr > base ) *--gptr = c;
}


int _Cdecl streambuf::snextc()
{
    return (gptr >= pptr) ? underflow() : (*(gptr++) & 0x7f);
}


int _Cdecl streambuf::sputc( int c )
{
    return (pptr >= eptr) ? overflow(c) : (*(pptr++) = c);
}


// add a null byte without advancing pointer
void _Cdecl streambuf::terminate( )
{
    if( pptr < eptr ) *pptr = 0;
}
