#include <stream.hxx>

class complex {
	double re, im;
  public:
  	complex (double r = 1., double i = 1.) : re(r), im(i) {}
        void operator += ( complex );
        void print() { cout << form("(%5.3f, %5.3f)\n", re, im); }
	
        friend complex operator + ( complex, complex );
	friend complex operator * ( complex, complex );
	friend int     operator ==( complex, complex );
};

complex operator +( complex a, complex b ) {
		return complex ( a.re + b.re, a.im + b.im );
}

complex operator *( complex a, complex b ) {
		return complex ( a.re * b.re - a.im * b.im,
				 a.re * b.im +  a.im * b.re );
}

int operator == ( complex a, complex b) {
	return ( a.re == b.re && a.im == b.im );
}

void complex::operator += ( complex a ) {
	re += a.re;
	im += a.im;
}

main() {
	const complex num1 (1, 0);	//num1 = (1.000, 0.000)
	complex num2 = 1.;		//num2 = (1.000, 1.000)
	complex num3 (3., 8.);		//num3 = (3.000, 8.000)
	complex num4;			//num4 = (1.000, 1.000)
	complex num5 = (4, 5);		//num5 = (5.000, 1.000) caution!
	complex num6 = (5, 6, 7, 8, 9); //num6 = (9.000, 1.000) caution!
	complex num7 = complex(5, 5);	//num7 = (5.000, 5.000)
	complex num8 = (num3, num1);	//num8 = (1.000, 0.000)
        double x = 1., y = 5., z = 3.;

	num4 += (num1 == num2? num3 : num1) + x * y + 1. / z;

	num4.print();	//prints out  (7.333, 3.000)
	num5.print();	//prints out  (5.000, 1.000)
	num6.print();	//prints out  (9.000, 1.000)
	num7.print();	//prints out  (5.000, 5.000)
	num8.print();	//prints out  (1.000, 0.000)
}

/* output:

(7.333, 3.000)
(5.000, 1.000)
(9.000, 1.000)
(5.000, 5.000)
(1.000, 0.000)

 */