#include <stdio.h>
#include <string.h>

enum year { freshman, sophomore, junior, senior };
enum support { ta, ra, fellowship, other };
enum level { undergraduate, graduate };

class student {

  private:               //private member only visible in base class
     level pr_member;    //equivalent to int pr_member;
     void set_pr_member() { pr_member = undergraduate; }  //private function

  protected:             //visible to subclasses derived from student
     int student_id;     
     float gpa;

  public:
     student (int id, float g) { set_pr_member(); student_id = id; gpa = g; }
     char name [15];
     char college [12];
     char major [14];
     year yr;
     void print() { printf("%-15s %-15s %4d %-12s %-14s %-9s %4.2f\n", 
                    l_char(pr_member), name, student_id, college, 
                    major, y_char(yr), gpa); 
     }
     friend char * y_char (year);	//convert year to characters
     friend char * l_char (level);	//convert level to characters
};

class grad_student : public student {
  private:
     support s;

  public:
     grad_student(support x, int id, float g) : (id, g) { s = x; }
     char dept [15];
     char thesis [50];
     void print() { printf("%-15s%-10s %-50s\n", dept, s_char(s), thesis); }

     friend char *s_char(support);	//convert support to characters
};

void proc1(student &), proc2(grad_student &);     //pass by reference

main() 
{
     student s1 (100, 2.99);
     grad_student gs1 (ta, 200, 3.01);

     proc1(s1);
     s1.print();

     proc2(gs1);
     gs1.print();
}

void proc1(student &sp)            //assign to sp
{ 
     strcpy(sp.name,    "Loope deLoop");
     strcpy(sp.college, "Art&Science"); 
     strcpy(sp.major,   "French"); 
     sp.yr = senior;
}

void proc2(grad_student &gsp)      //assign to gsp
{
     strcpy(gsp.name, "Yogi Bear");
     strcpy(gsp.dept, "Entertainment"); 
     strcpy(gsp.college, "Business");
     strcpy(gsp.thesis, "10000 ways to be smarter than the average bears");
     strcpy(gsp.major, ""); 
}

char * l_char (level l)  
{
     switch (l) {
          case undergraduate : return "Undergraduate";
          case graduate      : return "Graduate";
     }
}

char * y_char (year yr)  
{
     switch (yr) {
          case freshman : return "Freshman";
          case sophomore: return "Sophomore";
          case junior   : return "Junior";
          case senior   : return "Senior";
     }
}

char * s_char (support s)
{
     switch (s) {
          case ta : return "Ta";
          case ra : return "Ra";
          case fellowship : return "Fellowship";
          case other : return "Other";
     }
}
/* output:

Undergraduate   Loope deLoop     100 Art&Science  French         Senior    2.99
Entertainment  Ta         10000 ways to be smarter than the average bears   

*/