// SRO.CXX  demonstrates the use of Scope Resolution Operator ::

#include <stream.hxx>

void proc1(), proc2();

int i = 1;	//global variable


main()
{
	proc1();
	proc2();
}

void proc1()
{
	char c;

	class X {
		char c;
		class Y {
			char d;
			void foo (char e) { d = e; }
		};
		char goo (X *q) { return q->c; }
	};
}

void proc2()
{
	int i = 2;	//local variable

	{
		int n = i;	//the i is the local i
		int i = 3;	//hides the global and local i

		cout << "i = " << i << "\n";		//prints out  i = 3
		cout << "::i = " << ::i << "\n";	//prints out  ::i = 1
		cout << "n = " << n << "\n";		//prints out  n = 2

	}
	cout << "i = " << i << "\n";			//prints out  i = 2
	cout << "::i = " << ::i << "\n";		//prints out  ::i = 1
}

/* output:

i = 3
::i = 1
n = 2
i = 2
::i = 1

*/