/**************************************************************************
    Listing 15 - CIRCLE.CPP

    Written by Kevin D. Weeks, April 1990
    Released to the Public Domain
*/

#include "circle.hpp"

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Constructor - primary constructor. Copies of all attributes are
    accepted although init_color and init_width may be defaults.
*/
Circle::Circle(const int init_radius, const Point &init_center,
               const COLORS init_color, const line_widths init_width)
{
    struct linesettingstype line_type;

    if (init_width == DEFAULT)
    {
        getlinesettings(&line_type);
        width = (line_widths)line_type.thickness;
    }
    else
        width = init_width;

    if (init_color == DEFAULT)
        color = (COLORS)getcolor();
    else
        color = init_color;

    start_angle = 0;
    end_angle = 360;
    radius = init_radius;
    center = init_center;
    visible = FALSE;
}
