/*************************************************************************
    Listing 2 - DISPLAY.CPP

    Written by: Kevin D. Weeks, April 17, 1990
    Released to the Public Domain.
*/
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <math.h>
#include "display.hpp"


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Constructor - as coded, this constructor relies on the initgraph()
    function provided with the BGI to detect the display type and
    initialize it to the highest graphics mode. once this has been
    accomplished, the scaling factors for the virtual world are
    determined. the default virtual_size is 1000.
*/
Graphics_Display::Graphics_Display(char *path, const int world_size)
{
    int     mode;
    int     ret_code;
    int     x_aspect, y_aspect;

    driver = DETECT;
    // initialize graphics driver
    initgraph(&driver,&mode,path);
    if ((ret_code = graphresult()) != grOk)
    {
        printf("Error initializing graphics: %s\n\a",grapherrormsg(ret_code));
        exit(1);
    }

    // set up virtual world
    virtual_size = (double)world_size;
    getaspectratio(&x_aspect,&y_aspect);
    aspect_ratio = (float)x_aspect / 10000.0;
    max_x = getmaxx() + 1;
    max_y = getmaxy() + 1;
    x_scale = ((float)max_x / virtual_size) * aspect_ratio;
    y_scale = ((float)max_y / virtual_size);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    this function (not a method) rounds a floating point number off to the
    nearest whole number.
*/
double  round(double value)
{
    return floor(value + 0.5);
}
