/*************************************************************************
    Listing 1 - DISPLAY.HPP

    Written by: Kevin D. Weeks, April 17, 1990
    Released to the Public Domain.

    Description:
        This is the display control class. There can be ONLY ONE declared
    and that it must be declared globally! The classes that use the
    Graphics_Display object expect that it will be named "theDisplay".
    This class also provides the support attributes for the virtual
    world. There are a number of methods not included here for the sake
    of brevity that should be included, for instance: set_mode() and
    get_mode(), get_ and set_default_fill_pattern(), etc.
*/

#if !defined(DISPLAY_HPP)
#define DISPLAY_HPP

#include <graphics.h>

double  round(double value);

class Graphics_Display
{
  public:
// Constructors and destructor
    Graphics_Display(char *path,const int world_size = 1000.0);
    ~Graphics_Display(void)
    { closegraph(); };

// GET attribute methods.
    float       get_aspect_ratio(void)      // the value returned assumes
                { return aspect_ratio; };   //     that Y equals 1 and that
                                            //     X is a fraction of Y.
                                            //     the value value actually
                                            //     returned is the X com-
                                            //     ponent of the ratio.
    float       get_virtual_size(void)
                { return virtual_size; };
    int         get_max_x(void)
                { return max_x; };
    int         get_max_y(void)
                { return max_y; };
    int         get_driver(void)
                { return driver; };
    // the next two methods return the scaling factors to be used in
    // converting to and from virtual world co-ordinates and actual screen
    // co-ordinates.
    float       get_x_scale(void)
                { return x_scale; };
    float       get_y_scale(void)
                { return y_scale; };

// SET attribute methods.
    // the first two methods SHOULD NOT be used after the creation of
    // ANY Graphics_Object!
    void        set_aspect_ratio(const double ratio);
    void        set_virtual_size(const double size);
    void        set_default_bk_color(const COLORS new_color)
                { setbkcolor(new_color); };
    void        set_default_fg_color(const COLORS new_color)
                { setcolor(new_color); };

    // conversion methods.
    double      x_to_virtual(int x)
                { return round( ((float)x / x_scale) * aspect_ratio); };
    double      y_to_virtual(int y)
                { return round( (float)y / y_scale); };
    int         x_to_real(float x)
                { return (int)(round(x * x_scale)); };
    int         y_to_real(float y)
                { return (int)(round(y * y_scale)); };

  private:
    int         driver;                 // display driver to use. defined
                                        //     in include\graphics.h
    float       aspect_ratio;           // see get_aspect_ratio() above
    float       virtual_size;           // virtual world size.
                                        //     default = 1000.0 x 1000.0
    float       x_scale;                // see get_x_scale() and
    float       y_scale;                //     get_y_scale() above.
    int         max_x;                  // horizontal display size in pixels
    int         max_y;                  // vertical display size in pixels

};

#endif
