/**************************************************************************
    Listing 7 - DOT.CPP

    Written by Kevin D. Weeks, April 1990
    Released to the Public Domain
*/
#include "dot.hpp"

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Constructor - the location attribute will initialize itself so all
    we need to do is set the color to the default.
*/
Dot::Dot(void)
{
    color = (COLORS)getcolor();
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Constructor - since the copy constructor", Dot(const Dot &source),
    won't accept a pointer easily so we define a separate pointer
    constructor for convenience' sake.
*/
Dot::Dot(const Dot *source)
{
    location = source->location;
    color = source->color;
    visible = FALSE;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Constructor - primary constructor.
*/
Dot::Dot(const Point &init_location, COLORS init_color)
{
    location = init_location;
    if (init_color = (COLORS)DEFAULT)
        color = (COLORS)getcolor();
    else
        color = init_color;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void    Dot::set_color(COLORS new_color)
{
    if (new_color == (COLORS)DEFAULT)
        color = (COLORS)getcolor();
    else
        color = new_color;
    if (visible)
        draw();
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void    Dot::draw(void)
{
    putpixel(location.get_x(),location.get_y(),(int)color);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Draws the dot in the background color.
*/
void    Dot::erase(void)
{
    putpixel(location.get_x(),location.get_y(),getbkcolor());
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void    Dot::move_relative(Point &distance)
{
    erase();
    location += distance;
    draw();
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void    Dot::move_absolute(Point &new_location, Point &reference)
{
    erase();
    location += new_location - reference;
    draw();
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    this is the private method used by the copy constructor and the =
    operator. Note that the visible attribute is forced to FALSE.
*/
Dot     &Dot::copy(const Dot &source)
{
    location = source.location;
    color = source.color;
    visible = FALSE;
    return *this;
}
