/**************************************************************************
    Listing 6   -   DOT.HPP

    Written by Kevin D. Weeks, April 1990
    Released to the Public Domain
*/
#if !defined(DOT_HPP)
#define DOT_HPP

#include "graphobj.hpp"
#include "point.hpp"

class Dot : virtual public Graphics_Object
{
  public:
// Constructors and destructor.
            Dot(void);
            Dot(const Dot &source)
            { copy(source); };
            Dot(const Dot *source);
            Dot(const Point &init_location,
                COLORS init_color = (COLORS)DEFAULT);
            ~Dot(void)
            { if (visible) erase(); };

// Get attribute methods.
    virtual Point   &get_location(void)
                    { return location; };
    virtual int     get_x(void)
                    { return location.get_x(); };
    virtual int     get_y(void)
                    { return location.get_y(); };
    virtual COLORS  get_color(void)
                    { return color; };

// Set attribute methods.
    // NOTE: if the object is visible then attempts to modify its position
    // attributes will fail quietly.
    virtual void    set_location(const Point &new_location)
                     { if (!visible) location = new_location; };
    virtual void    set_x(const int new_x)
                     { if (!visible) location.set_x(new_x); };
    virtual void    set_y(const int new_y)
                     { if (!visible) location.set_y(new_y); };
    virtual void    set_color(COLORS new_color = (COLORS)DEFAULT);

// Inherited methods.
    virtual void    draw(void);
    virtual void    erase(void);
    virtual void    move_relative(Point &distance);
    virtual void    move_absolute(Point &new_location, Point &reference);

// Operators.
    Dot     &operator=(const Dot &source)
            { return copy(source); };

  private:
    // this method is used by both the copy constructor and oprator=
    Dot            &copy(const Dot &source);

    // the attributes should be self-evident
    Point           location;
    COLORS          color;
};

#endif
