/**************************************************************************
    Listing 5 - GRAPHOBJ.HPP

    Written by Kevin D. Weeks, April 1990
    Released to the Public Domain

        This is an abstract base class. All methods are declared as pure
    virtual functions. I considered adding references to COLOR but decided
    against it since Polygons and Circles may have both a fill_color and
    line_color(s).

    General rules for descendants of this class:
        Attempts to set the co-ordinates of "visible" objects will fail
            quietly.
        A "copy constructor" and an operator=() method should always be
            defined. Their primary purpose is to ensure that the "visible"
            attribute is always set to FALSE until the specific object is
            explicitly draw()n.
*/
#if !defined(GRAPHOBJ_HPP)
#define GRAPHOBJ_HPP

#include <graphics.h>
#include "point.hpp"

// DEFAULT is used by descendant classes to indicate that default para-
// meters should be used.
#define DEFAULT     -1

class Graphics_Object
{
  public:
    // the methods followed by " = 0;" are 'pure' methods
    virtual void    draw(void) = 0;
    virtual void    erase(void) = 0;
    virtual void    move_relative(Point &distance) = 0;
    virtual void    move_absolute(Point &new_location, Point &reference) = 0;
    virtual Bool    is_visible(void)
                    { return visible; };
  protected:
    Bool    visible;
};

#endif
