/**************************************************************************
    Listing 8 - LINE.HPP

    Written by Kevin D. Weeks, April 1990
    Released to the Public Domain
*/
#if !defined(LINE_HPP)
#define LINE_HPP

#include "graphobj.hpp"
#include "point.hpp"

class Line : virtual public Graphics_Object
{
  public:
// Constructors and destructor.
    Line(void);
    Line(const Line &source)
        { copy(source); };
    Line(const Line *source);
    Line(const Point begin, const Point finish,
         const COLORS init_color = (COLORS)DEFAULT,
         const line_styles init_style = (line_styles)DEFAULT,
         const line_widths init_width = (line_widths)DEFAULT);
    ~Line(void)
        { if(visible) erase(); };

// Get attribute methods
    virtual Point&  get_start(void)
                    { return start; };
    virtual Point&  get_end(void)
                    { return end; };
    virtual line_styles get_style(void)
                    { return style; };
    virtual line_widths get_width(void)
                    { return width; };
    virtual COLORS  get_color(void)
                    { return color; };

// Set attribute methods.
    // NOTE: if the object is visible the set_start() and set_end()
    // methods will fail quietly.
    virtual void    set_start(const Point new_start)
                    { if (!visible) start = new_start; };
    virtual void    set_end(const Point new_end)
                    { if (!visible) end = new_end; };

    // color, style, and width can be changed whether the line is visible
    // or not.
    virtual void    set_style(line_styles new_style = (line_styles)DEFAULT);
    virtual void    set_width(line_widths new_width = (line_widths)DEFAULT);
    virtual void    set_color(const COLORS new_color = (COLORS)DEFAULT);

// Inherited methods.
    virtual void    draw(void);
    virtual void    erase(void);
    virtual void    move_relative(Point &distance);
    virtual void    move_absolute(Point &new_location, Point &reference);

// Operators.
    Line            &operator=(const Line &source)
                    { return copy(source); };

  private:
    // this method is used by both the copy constructor and operator =
    Line            &copy(const Line &source);

    // these attributes should be obvious
    Point           start;
    Point           end;
    COLORS          color;              // COLORS, line_styles, and
    line_styles     style;              //    line_widths are defined in
    line_widths     width;              //    include\graphics.h
};

#endif
