/**************************************************************************
    Listing 4   -   POINT.CPP

    Written by Kevin D. Weeks, April 1990
    Released to the Public Domain
*/
#include <math.h>
#include "point.hpp"
#include "display.hpp"

extern Graphics_Display theDisplay;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Constructor - creates an empty instance. all attributes are set to
    zero.
*/
Point::Point(void)
{
    x = y = 0;
    virtual_x = virtual_y = 0.0;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Constructor - uses set_xy() method to initialize.
*/
Point::Point(const int init_x, const int init_y)
{
    set_xy(init_x,init_y);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    Constructor - uses set_xy() method to initialize.
*/
Point::Point(const double init_x, const double init_y)
{
    set_xy(init_x,init_y);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    change real X co-ordinate. if out of legal range, force to max.
*/
void    Point::set_x(const int new_x)
{
    // check range
    if (new_x > theDisplay.get_max_x())
        x = theDisplay.get_max_x();
    else
        x = new_x;

    // set virtual co-ordinate
    virtual_x = theDisplay.x_to_virtual(x);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    change virtual X co-ordinate. if out of legal range, force to max.
*/
void    Point::set_x(const double new_x)
{
    // check range
    if (new_x > theDisplay.get_virtual_size())
        virtual_x = theDisplay.get_virtual_size();
    else
        virtual_x = new_x;

    // set real co-ordinate
    x = theDisplay.x_to_real(virtual_x);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    change real Y co-ordinate. if out of legal range, force to max.
*/
void    Point::set_y(const int new_y)
{
    // check range
    if (new_y > theDisplay.get_max_y())
        y = theDisplay.get_max_y();
    else
        y = new_y;

    // set virtual co-ordinate
    virtual_y = theDisplay.y_to_virtual(y);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    change virtual Y co-ordinate. if out of legal range, force to max.
*/
void    Point::set_y(const double new_y)
{
    // check range
    if (new_y > theDisplay.get_virtual_size())
        virtual_y = theDisplay.get_virtual_size();
    else
        virtual_y = new_y;

    // set real co-ordinate
    y = theDisplay.y_to_real(virtual_y);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    change both real co-ordinates. if out of legal range, force them to max.
    then set the virtual world co-ordinates.
*/
void    Point::set_xy(const int new_x, const int new_y)
{
    // check range
    if (new_x > theDisplay.get_max_x())
        x = theDisplay.get_max_x();
    else
        x = new_x;
    if (new_y > theDisplay.get_max_y())
        y = theDisplay.get_max_y();
    else
        y = new_y;

    // update virtual co-ordinates
    virtual_x = theDisplay.x_to_virtual(x);
    virtual_y = theDisplay.y_to_virtual(y);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    change both virtual co-ordinates. if out of legal range, force them to
    max. then set the real co-ordinates.
*/
void    Point::set_xy(const double new_x, const double new_y)
{
    // check range
    if (new_x > theDisplay.get_virtual_size())
        virtual_x = theDisplay.get_virtual_size();
    else
        virtual_x = new_x;
    if (new_y > theDisplay.get_virtual_size())
        virtual_y = theDisplay.get_virtual_size();
    else
        virtual_y = new_y;

    // update real co-ordinates
    x = theDisplay.x_to_real(virtual_x);
    y = theDisplay.y_to_real(virtual_y);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    add one point to another. if the result is out of legal range,
    force the result to max.
*/
Point   &Point::operator+=(Point &addend)
{
    if ((virtual_x += addend.get_virtual_x()) > theDisplay.get_virtual_size())
        virtual_x = theDisplay.get_virtual_size();
    if ((virtual_y += addend.get_virtual_y()) > theDisplay.get_virtual_size())
        virtual_y = theDisplay.get_virtual_size();
    x = theDisplay.x_to_real(virtual_x);
    y = theDisplay.y_to_real(virtual_y);
    return *this;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    subtract one point from another. if the result is out of legal range,
    force the result to 0.
*/
Point   &Point::operator-=(Point &subtrahend)
{
    if ((virtual_x -= subtrahend.get_virtual_x()) < 0.0)
        virtual_x = 0.0;
    if ((virtual_y -= subtrahend.get_virtual_y()) > 0.0)
        virtual_y = 0.0;
    x = theDisplay.x_to_real(virtual_x);
    y = theDisplay.y_to_real(virtual_y);
    return *this;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    compare two points and is both co-ordinates are equal return TRUE.
*/
Bool    Point::operator==(Point &comparator)
{
    if (x == comparator.get_x())
        if (y == comparator.get_y())
           return TRUE;
    return FALSE;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    compare two points and if this point is to the right of or below the
    comparator then return TRUE.
*/
Bool    Point::operator>(Point &comparator)
{
    if ((x >= comparator.get_x()) && (y > comparator.get_y()))
        return TRUE;
    else
        if ((x > comparator.get_x()) && (y >= comparator.get_y()))
            return TRUE;
    return FALSE;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    compare two points and if this point is to the left of or above the
    comparator then return TRUE.
*/
Bool    Point::operator<(Point &comparator)
{
    if ((x <= comparator.get_x()) && (y < comparator.get_y()))
        return TRUE;
    else
        if ((x < comparator.get_x()) && (y <= comparator.get_y()))
            return TRUE;
    return FALSE;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    compare two points and if this point is to the left of or above or equal
    to the comparator then return TRUE.
*/
Bool    Point::operator<=(Point &comparator)
{
    if ((x <= comparator.get_x()) && (y <= comparator.get_y()))
        return TRUE;
    return FALSE;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    compare two points and if this point is to the right of or below or equal
    to the comparator then return TRUE.
*/
Bool    Point::operator>=(Point &comparator)
{
    if ((x >= comparator.get_x()) && (y >= comparator.get_y()))
        return TRUE;
    return FALSE;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    this is a friend of the Point class. it adds two point s together and
    returns the result as a third Point.
*/
Point   &operator+(Point &augend, Point &addend)
{
    static Point   result;

    result.virtual_x = augend.virtual_x + addend.virtual_x;
    result.virtual_y = augend.virtual_y + addend.virtual_y;
    result.x = theDisplay.x_to_real(result.virtual_x);
    result.y = theDisplay.y_to_real(result.virtual_y);
    return result;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    this is a friend of the Point class. it subtracts two points and
    returns the result as a third Point.
*/
Point   &operator-(Point &minuend, Point &subtrahend)
{
    static Point   result;

    result.virtual_x = minuend.virtual_x - subtrahend.virtual_x;
    result.virtual_y = minuend.virtual_y - subtrahend.virtual_y;
    result.x = theDisplay.x_to_real(result.virtual_x);
    result.y = theDisplay.y_to_real(result.virtual_y);
    return result;
}
