/**************************************************************************
    Listing 3 - POINT.HPP

    Written by Kevin D. Weeks, April 1990
    Released to the Public Domain
*/

#if !defined(POINT_HPP)
#define POINT_HPP      1

enum Bool {FALSE, TRUE};

class Point
{
  public:
// Constructors.
    // Note: the compliler's "copy constructor" should work just fine so
    // none is provided. No destructor is declared since no cleanup is
    // neccessary
    Point(void);
    Point(const Point *source);
    Point(const int init_x, const int init_y);
    Point(const double init_x, const double init_y);

// Get attribute methods.
    int     get_x(void)
            { return x; };
    double  get_virtual_x(void)
            { return virtual_x; };
    int     get_y(void)
            { return y; };
    double  get_virtual_y(void)
            { return virtual_y; };

// Set attribute methods.
    void    set_x(const int new_x);
    void    set_x(const double new_x);
    void    set_y(const int new_y);
    void    set_y(const double new_y);
    void    set_xy(const int new_x, const int new_y);
    void    set_xy(const double new_x, const double new_y);

// Operators.
    Point   &operator+=(Point &addend);
    Point   &operator-=(Point &subtrahend);
    Bool    operator==(Point &comparator);
    Bool    operator>(Point &comparator);
    Bool    operator<(Point &comparator);
    Bool    operator>=(Point &comparator);
    Bool    operator<=(Point &comparator);

  private:
    double          virtual_x;              // virtual world co-ordinate
    double          virtual_y;              // virtual world co-ordinate
    int             x;                      // real world co-ordinate
    int             y;                      // real world co-ordinate

    // these are declared and implemented as "friend" methods so that they
    // will work as binary operators.
    friend Point    &operator+(Point &augend, Point &addend);
    friend Point    &operator-(Point &minuend, Point &subtrahend);
};

#endif
