
//Example using BI_IBagAsVector and BI_BagAsVectorIterator with a
//user-defined data class

//========================================================================
//  The following example routines have been provided by the Technical
//  Support staff at Borland International.  They are provided as a
//  courtesy and not as part of a Borland product, and as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================

#include <bags.h>

#include <string.h>
#include <iostreams.h>

class mydata{
    char* p;
    int size;
public:
    mydata(int sz, char* s){ p = new char[sz]; strcpy(p,s);}
    mydata(){p = new char[20];strcpy(p,"default");}
    mydata(const mydata&);             //copy constructor
    operator const char*(){ return p;}     //conversion operator
    ~mydata(){delete p;}
    mydata& operator=(const mydata&);
    int operator==(const mydata&) const;
    int operator<(const mydata&);
    int operator>(const mydata&);
    int operator!=(const mydata&);
};

mydata::mydata(const mydata& a)
{
        p = new char[size=a.size];
        strcpy(p,a.p);
}

mydata& mydata::operator=(const mydata& a)
{
        if (this!= &a)
        {
                delete p;
                p = new char[size=a.size];
                strcpy(p,a.p);
        }
        return *this;
}

int mydata::operator==(const mydata& a) const
{
        if (strcmp(p,a.p) == 0)
            return 1;
        else
            return 0;
}

int mydata::operator!=(const mydata& a)
{
        if (strcmp(p,a.p) != 0)
            return 1;
        else
            return 0;
}

int mydata::operator<(const mydata& a)
{
        if(strcmp(p,a.p) < 0)
          return 1;
        else
          return 0;
}

int mydata::operator>(const mydata& a)
{
        if(strcmp(p,a.p) > 0)
          return 1;
        else
          return 0;
}

typedef BI_IBagAsVector<mydata> strbag;
typedef BI_IBagAsVectorIterator<mydata> strbagit;

int main()
{
     mydata* s1 = new mydata(20,"string1");
     mydata* s2 = new mydata(20,"string2");
     mydata* s3 = new mydata(20,"string3");

     strbag* bag = new BI_IBagAsVector<mydata>(3);

     bag->add(s1);   //add pointers to the Indirect Bag
     bag->add(s2);
     bag->add(s3);

     strbagit* bagit = new BI_IBagAsVectorIterator<mydata>(*bag);

     cout<<"Iterating through the pointers:"<<endl;
     cout<<bagit->current()<<endl;
     (*bagit)++;
     cout<<bagit->current()<<endl;
     (*bagit)++;
     cout<<bagit->current()<<endl;

     bagit->restart();

     cout<<"\nIterating through the contents of the pointers:"<<endl;
     cout<<*bagit->current()<<endl;
     ++(*bagit);
     cout<<*bagit->current()<<endl;
     (*bagit)++;
     cout<<*bagit->current()<<endl;

     return 0;
}

