//Bigarray.cpp Implemention of Big array by Kelvin Cannon 21/3/90 Copyright 1990
#include "bigarray.hpp"

int	big_error=0;
char *err_mess;

void default_error(int n,char *m)
{
	big_error=n;
	err_mess=m;
}

typedef void (* PFC) (int,char *);
PFC bigarray_handler=default_error;

bigarray::bigarray(int elems)
{
	elements=0L;
	elem_size=elems;
	dummy=farmalloc((long)elem_size);
	if(!dummy)
	{
		bigarray_handler(1,"Bigarray - Not enough memory");
		return;
	}
	reset_mem(dummy,(long)elem_size);
	set_flag=0;
}

int bigarray::set_size(long size)
{
	if(set_flag)
	{
		bigarray_handler(1,"Bigarray - Size allready set");
		return 0;
	}
	body=farmalloc(size*elem_size);
	if(!body)
	{
		bigarray_handler(1,"Bigarray - Not enough memory");
		return 0;
	}
	reset_mem(body,elem_size * size);
	elements=size;
	set_flag=1;
	return 1;
}

char far *bigarray::access(long i)
{
	char far *farptr;
	if(i>=elements)
	{
		bigarray_handler(1,"Bigarray - Array access out of range");
		return dummy;
	}
	farptr=_farptr_fromlong(_farptr_tolong(body)+i*elem_size);
	return farptr;
}

void bigarray::reset_mem(char far *start,long num)
{
	unsigned seg=FP_SEG(start);
	unsigned para=(num+15)/16;
	zero_mem(seg,para);
}

PFC set_bigarray_handler(PFC handler)
{
	PFC local=bigarray_handler;
	bigarray_handler=handler;
	return local;
}

