//Bigarray.hpp Big array Class by Kelvin Cannon 21/3/90 Copyright 1990.
//Allows an array of objects to be as big as available memory in small model.
#ifndef BIGARRAYHPP
#define BIGARRAYHPP
#include <generic.hpp>
#include <dos.h>

extern "C" zero_mem(unsigned,unsigned);

class bigarray 
{
	char far *dummy;
	char far *body;
	char set_flag;
	int elem_size;
	long elements;
	void reset_mem(char far *,long);
public:
	bigarray(int);
	~bigarray(void) {farfree(body); farfree(dummy);}
	char far* access(long);
	int set_size(long);
	long size(void) {return elements;}
};

#define gbigarray(type) name2(type,gbigarray)

#define gbigarraydeclare(type)							\
struct gbigarray(type) : public bigarray {				\
	gbigarray(type)() : (sizeof(type)) {}				\
	type far* operator[](long i)						\
		{return ((type far*) bigarray::access(i));}		\
	long size(void) {return bigarray::size();}			\
};\

#if 0
Use:
	
	#include "bigarray.hpp"
	declare(gbigarray,type);	Define a class for type
	gbigarray(type) x;			Declare an instance
	
	This constructor takes no arguments.
	If this fails it calls a default error handler which sets up two 
	Global variables int big_error and char *err_mess.
	
	int x.set_size(long);
	
	Set size of array at run time. Can only be set once for each instance.
	Returns 0 if not enough memory or if size was allready set.
	Returns 1 if ok.
	
	type *p=x[long];
	Return pointer to array element.
	
	long num_elements = x.size();
	Return number of elements in array
	
	int big_error Set to 1 if there as been an error.
	char *err_mess Contains pointer to error message.
	
	Link with resetmem.obj
#endif
#endif

