// ObjectWindows - (C) Copyright 1992 by Borland International
// File: BITSAVE.CPP

#include "owl.h"
#define CM_SAVE    101
#define CM_RESTORE 102
#define CM_CLEAR   103

/* 
   This example is a modified OWL example, SCRIBAPP.CPP, which 
   demonstrates using a memory device context to hold a bitmap. The 
   application is essentially a scratchpad on which the user can 
   draw with the left mouse button. The example has been modified 
   to allow saving, clearing, and restoring of the drawing. The is 
   accomplished by creating a Memory Device context ( with a call 
   to CreateCompatibleDC ) into which a compatible bitmap is selected 
   ( CreateCompatibleBitmap and SelectObject ). BitBlt is used to
   save/refresh the drawings. Note that this example has some limitations
   with regard to resizing and/or moving of the Window, as the logic of 
   saving to and restoring assumes the original size and position of the
   main Window. This could be handled by responding to resize messages 
   and updating the rectangle used to save/refresh the drawing. We could
   improve the functionality of 'backing up' of the drawing by 'saving' 
   in response to a right mouse button down, or setting a timer or using
   IdleAction for automatic backing up. Additionally, we should add the 
   recommended cleanup and restoration in the destructor ( see online help
   for SelectObject, CreateCompatibleDC, etc. )
*/    




  /* Declare TScribbleApp, a TApplication descendant */

class TScribbleApp : public TApplication
{
public:
  TScribbleApp(LPSTR name, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
    : TApplication(name, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

  /* Declare TScribbleWindow, a TWindow descendant */
class TScribbleWindow : public TWindow
{
 HDC hMemDC;
 HBITMAP hBitmap;
 RECT rect;
public:
  HDC HoldDC;
  BOOL ButtonDown ;
  TScribbleWindow(PTWindowsObject Parent,LPSTR name);
  virtual void WMLButtonDown(RTMessage Msg) = [WM_FIRST + WM_LBUTTONDOWN];
  virtual void WMLButtonUp(RTMessage Msg) = [WM_FIRST + WM_LBUTTONUP];
  virtual void WMMouseMove(RTMessage Msg) = [WM_FIRST + WM_MOUSEMOVE];
  virtual void WMRButtonDown(RTMessage Msg) = [WM_FIRST + WM_RBUTTONDOWN];
  virtual void CMSave( RTMessage Msg )
    = [ CM_FIRST + CM_SAVE ];
  virtual void CMRestore( RTMessage Msg )
    = [ CM_FIRST + CM_RESTORE ];
  virtual void CMClear( RTMessage Msg )
    = [ CM_FIRST + CM_CLEAR ];
  virtual void SetupWindow();
  ~TScribbleWindow();
};
TScribbleWindow::~TScribbleWindow()
{

}
void TScribbleWindow::SetupWindow()
{

 TWindow::SetupWindow();

 // set up a memory device context to save the drawing
 GetClientRect( HWindow, &rect );
 HDC hDC = GetDC( HWindow );
 hMemDC = CreateCompatibleDC(hDC);
 // create a compatible bitmap for selection into
 // the memory device context
 hBitmap = CreateCompatibleBitmap( hDC,rect.right - rect.left,
                      rect.bottom - rect.top	    );
 ReleaseDC( HWindow, hDC );
 SelectObject( hMemDC, hBitmap );
 // intialize the memory bitmap to whiteness
 BitBlt( hMemDC, rect.left, rect.top, rect.right - rect.left,
	  rect.bottom - rect.top, hMemDC, 0, 0, WHITENESS );
}

void TScribbleWindow::CMSave( RTMessage )
{
 HDC hDC = GetDC( HWindow );
 BitBlt( hMemDC, rect.left, rect.top,rect.right - rect.left,
    rect.bottom - rect.top, hDC, 0, 0, SRCCOPY );
 ReleaseDC( HWindow, hDC );

}
void TScribbleWindow::CMRestore( RTMessage )
{
 HDC hDC = GetDC( HWindow );
 BitBlt( hDC, rect.left, rect.top, rect.right - rect.left,
	 rect.bottom - rect.top, hMemDC, 0, 0, SRCCOPY );
 ReleaseDC( HWindow, hDC );
}
void TScribbleWindow::CMClear( RTMessage )
{
 HDC hDC = GetDC( HWindow );
 BitBlt( hDC, rect.left, rect.top, rect.right - rect.left,
	  rect.bottom - rect.top, hMemDC, 0, 0, WHITENESS );
 ReleaseDC( HWindow, hDC );
}
TScribbleWindow::TScribbleWindow(PTWindowsObject AParent, LPSTR AName)
                : TWindow(AParent, AName)
{
  AssignMenu("MENU_1");
  ButtonDown = FALSE;
}

/* Define a TScribbleWindow's response to an incoming "left-button-down"
  message.  In response, TScribbleWindows prepare to draw a line,
  setting the current position in client area, retrieving a display
  context from MS-Windows, and capturing mouse input. */
void TScribbleWindow::WMLButtonDown(RTMessage Msg)
{
  if (!ButtonDown)
  {
    ButtonDown = TRUE;
    // Direct all subsequent mouse input to this window
    SetCapture(HWindow); //MS-Windows function
    HoldDC = GetDC(HWindow);
    MoveTo (HoldDC, Msg.LP.Lo, Msg.LP.Hi);
  }
}

/* Define a TScribbleWindow's response to an incoming "mouse-move"
  message.  In response, TScribbleWindows draw a line using the new
  position of the mouse. */
void TScribbleWindow::WMMouseMove(RTMessage Msg)
{
  if (ButtonDown)
    LineTo(HoldDC, Msg.LP.Lo, Msg.LP.Hi);   // draw the line
}


/* Define a TScribbleWindow's response to an incoming "left-button-up"
  message.  In response, TScribbleWindows "cleanup" required after a
  line is drawn, releasing the display context to MS-Windows, and
  releasing mouse input. */
void TScribbleWindow::WMLButtonUp(RTMessage)
{
  if (ButtonDown)
  {
    ReleaseCapture();
    ReleaseDC(HWindow, HoldDC);
    ButtonDown = FALSE;
  }
}

/* Define a TScribbleWindow's response to an incoming
   "right-button-down" message.  In response, TScribbleWindows "clear"
   their client area. */
void TScribbleWindow::WMRButtonDown(RTMessage)
{
  // Invalidate the entire window
  InvalidateRect(HWindow, LPRECT(NULL), TRUE);  // MS-Windows function
  // MS-Windows will send WM_PAINT message to the window
}

void TScribbleApp::InitMainWindow()
{
  MainWindow = new TScribbleWindow(NULL, "Scribble Away!");
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TScribbleApp ScribbleApp ("Scribble", hInstance, hPrevInstance,
    lpCmdLine, nCmdShow);
  ScribbleApp.Run();
  return ScribbleApp.Status;
}

