//========================================================================
//  The following example routines have been provided by the Technical
//  Support staff at Borland International.  They are provided as a
//  courtesy and not as part of a Borland product, and as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================
//
//  Turbo Vision - Responding to cmReleased events in a Dialog box
//    and changing other fields in the Dialog based on the value of
//    a control.
//
//------------------------------------------------------------------------

#define Uses_THistory
#define Uses_MsgBox
#define Uses_TProgram
#define Uses_TApplication
#define Uses_TKeys
#define Uses_TRect
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_TView
#define Uses_TWindow
#define Uses_TFrame
#define Uses_TScroller
#define Uses_TScrollBar
#define Uses_TDialog
#define Uses_TButton
#define Uses_TSItem
#define Uses_TCheckBoxes
#define Uses_TRadioButtons
#define Uses_TLabel
#define Uses_TInputLine
#define Uses_TMenu

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <tv.h>

const int cmAbout    = 100;
const int cmDialog1  = 101;

//
//define, instantiate and initialize the dialog transfer structure
//
struct dialogstruct
{
  ushort chk;
  ushort rad;
  char first[30];
  char last[30];
} s = { 0, 0, "", ""};


//
//main application class
//
class TMyApp : public TApplication
{

 public:
   TMyApp();
   static TMenuBar *initMenuBar( TRect );
   static TStatusLine *initStatusLine( TRect );
   void handleEvent(TEvent& event);

 protected:
   void Dialog1(void);

};


//
//Sub class the TDialog class to add new functionality
//
class myDialog : public TDialog
{
  //
  //keep a pointer to the radiobutton in the dialog
  //This pointer will be used later in the handleEvent of the class
  //
  TRadioButtons *radioPtr;

  public:
    myDialog(const TRect& bounds, const char *aTitle);
    void handleEvent( TEvent& event);

};


//
//class constructor for my new dialog class "myDialog"
//
myDialog::myDialog(const TRect& bounds, const char *aTitle): TDialog( bounds, aTitle),
       TWindowInit(initFrame)
{

      TView *b;

      //
      //make and insert checkBoxes
      //
      b = new TCheckBoxes( TRect( 3, 3, 41, 7),
      new TSItem( "Assembly",
      new TSItem( "Basic",
      new TSItem( "Debugger",
      new TSItem( "Profiler",
      new TSItem( "Engine",
      new TSItem( "Windows",
      new TSItem( "Letters",
      new TSItem( "OWL",
      new TSItem( "TV",
      new TSItem( "DOS",
      new TSItem( "OS/2",
      new TSItem( "C++", 0 )
      ))))))))))));
    insert( b );
    insert( new TLabel( TRect( 2, 2, 10, 3), "~P~roduct", b ));
  
    //
    //make and insert the radioButtons
    //
    b = new TRadioButtons( TRect( 3, 10, 41, 13),
      new TSItem( "Do Nothing",
      new TSItem( "Check All and enter Name",
      new TSItem( "Clear All fields", 0)
      )));
    insert( b );
    insert( new TLabel( TRect( 2, 9, 13, 10), "~M~ain Duty", b ));
    //
    //set the class global pointer to the radiobuttons pointer
    //
    radioPtr = (TRadioButtons *)b;

    //
    //make and insert the name inputline
    //
    b = new TInputLine( TRect( 3, 15, 41, 16 ), 30 );
    insert( b );
    insert( new TLabel( TRect( 2, 14, 34, 15 ),"~F~irst Name", b ));
    insert( new THistory( TRect( 39, 15, 42, 16),(TInputLine *)b, 101 ));

    //
    //make and insert the last name inputline
    //
    b = new TInputLine( TRect( 3, 18, 41, 19 ), 30 );
    insert( b );
    insert( new TLabel(TRect( 2, 17, 34, 18 ),"~L~ast Name", b ));
    insert( new THistory( TRect( 39, 18, 42, 19), (TInputLine *)b, 102 ));

    //
    //make and insert buttons
    //
    insert( new TButton( TRect( 5, 20, 13, 22 ),"~O~k",cmOK,bfDefault ));
    insert( new TButton( TRect( 28, 20, 38, 22 ),"~C~ancel",cmCancel,bfNormal ));

    //
    //set the initial data into the dialog box
    //
    setData( &s );

}


//
//if the event is a broadcast of type cmReleasedFocus and it was sent
//by the radioButton then getData(), take action base on the current
//value of the radioButtons
//
void myDialog::handleEvent( TEvent& event)
{

   if( event.what == evBroadcast && event.message.command == cmReleasedFocus )
   {
      if( event.message.infoPtr == radioPtr )
      {
         getData( &s );
         if( s.rad == 1 )
         {
            strcpy(s.first, "Frank" );
            strcpy(s.last, "Borland" );
            s.chk = 4095;
            setData(&s);
         }
         else if( s.rad == 2 )
         {
            strcpy(s.first, "");
            strcpy(s.last, "");
            s.chk = 0;
            setData(&s);
         }
      }
   }

   //
   //call TDialog's handleEvent after our processing otherwise it
   //will handle the cmReleasedFocus events
   //
   TDialog::handleEvent( event );

}

//
//member function of TMyApp which creates and executes a "myDialog"
//
void TMyApp::Dialog1()
{

  myDialog *pd = new myDialog( TRect( 18, 0, 62, 23), "Operator Input" );
	if( pd )
	{
     deskTop->execView( pd );
     destroy( pd );
  }

}


TMyApp::TMyApp() :
	TProgInit( &initStatusLine,
		   &initMenuBar,
		   &initDeskTop
		 )
{}

//
//TMyApp handleEvent processes the menuBar and statusLine commands
//
void TMyApp::handleEvent(TEvent& event)
{
   TApplication::handleEvent( event );

   if( event.what == evCommand )
   {
      switch( event.message.command)
      {
         case cmDialog1:
            Dialog1();
            break;

         default:
           break;
      }
      clearEvent( event );
   }

}


TStatusLine *TMyApp::initStatusLine(TRect r)
{
	r.a.y = r.b.y - 1;

   return new TStatusLine( r,
       *new TStatusDef( 0, 0xFFFF) +
       *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit) +
       *new TStatusItem( "~Alt-A~ About", kbAltA, cmDialog1)
       );
}


TMenuBar *TMyApp::initMenuBar( TRect r )
{
	r.b.y = r.a.y + 1;

   TMenuItem *one =
      new TMenuItem("~E~xit",cmQuit,kbAltX,hcNoContext, 0, 0);
      
   TMenuItem *two =
      new TMenuItem("~A~bout",cmAbout,kbAltA,hcNoContext,0, one);
      
   TMenuItem *three =
      new TMenuItem("~D~ialog",cmDialog1,kbAltD,hcNoContext,0, two);

   return new TMenuBar( r, new TMenu( *three ));


}


int main()
{

   TMyApp myApp;
   myApp.run();
   return 0;
}
