/*********************************************************************
**                           Inputest.cpp
**
**
**  Example of a TInputline implementation of a range inputLine.
**
**
**  Compile with: Bcc -ml inputest.cpp rangelin.cpp tv.lib
**
**********************************************************************
**
**  DISCLAIMER: You have the right to use this technical information
**  subject to the terms of the No-Nonsense License Statement that
**  you received with the Borland product to which this information
**  pertains.
**
***********************************************************************/

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TEventQueue
#define Uses_TEvent
#define Uses_TKeys
#define Uses_TRect
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_TView
#define Uses_TWindow
#define Uses_TMenu
#define Uses_TDialog
#define Uses_TStaticText
#define Uses_TInputLine
#define Uses_TButton
#define Uses_TRect
#define Uses_TLabel


#include <stdio.h>        //for puts
#include "rangelin.hpp"   //rangeline
#include <tv.h>

const int cmTest = 100;


class TMyApp : public TApplication
{

public:
	TMyApp();
	void handleEvent(TEvent& event);
	void Test(void);

protected:
	static TMenuBar *initMenuBar( TRect );
	static TStatusLine *initStatusLine( TRect );

};


TMyApp::TMyApp() :
	TProgInit( initStatusLine,
		   initMenuBar,
		   initDeskTop
		 )
{
   //
   //put an event on the queue to bring up the dialog on start-up.
   //
   TEvent e;
   e.what = evCommand;
   e.message.command = cmTest;
   putEvent( e );

}


void TMyApp::Test(void)
{

    TDialog *pd = new TDialog( TRect( 10,2,70,20), "Test Dialog");
    if( validView( pd ) )
    {
       RangeLine *numLine = new RangeLine( TRect(5,3,25,4), 50, ifNum );
       pd->insert(numLine);
       pd->insert( new TLabel(TRect(4,2,20,3),"~N~umber Input", numLine));

       RangeLine *LowerLine = new RangeLine( TRect(5,7,25,8), 50, ifLower);
       pd->insert(LowerLine);
       pd->insert( new TLabel(TRect(4,6,20,7),"~L~ower Case", LowerLine));

       RangeLine *UpperLine = new RangeLine( TRect(5,11,25,12), 50, ifUpper);
       pd->insert(UpperLine);
       pd->insert( new TLabel(TRect(4,10,20,11),"~U~pper Case", UpperLine));

       RangeLine *DefaultLine = new RangeLine( TRect(5,14,25,15), 50, ifDefault);
       pd->insert(DefaultLine);
       pd->insert( new TLabel(TRect(4,13,20,14),"~D~efault", DefaultLine));

       RangeLine *UpperLower = new RangeLine( TRect(35,3,55,4), 50, ifUpper|ifLower);
       pd->insert(UpperLower);
       pd->insert( new TLabel(TRect(34,2,55,3),"~B~oth Upper and Lower", UpperLower));

       RangeLine *NumRange = new RangeLine( TRect(35,7,55,8), 50, ifNum|ifRange, '0', '5');
       pd->insert(NumRange);
       pd->insert( new TLabel(TRect(34,6,55,7),"~D~igits 0-5", NumRange));

       RangeLine *AlphaSpace = new RangeLine( TRect(35,11,55,12), 50, ifUpper|ifLower|ifSpace);
       pd->insert(AlphaSpace);
       pd->insert( new TLabel(TRect(34,10,55,11),"~A~lpha w/Space", AlphaSpace));

       pd->selectNext(False);

       deskTop->execView(pd);
    }
    destroy(pd);

}


void TMyApp::handleEvent(TEvent& event)
{

  TApplication::handleEvent( event );

   if( event.what == evCommand )
   {
      switch( event.message.command)
      {
	case cmTest:
	  Test();
	  break;

	default:
	  break;
      }
      clearEvent( event );
   }


}


TStatusLine *TMyApp::initStatusLine(TRect r)
{
   r.a.y = r.b.y - 1;

   return new TStatusLine( r,
       *new TStatusDef( 0, 0xFFFF) +
       *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit) +
       *new TStatusItem( "~Alt-T~ Test", kbAltT, cmTest)
       );

}


TMenuBar *TMyApp::initMenuBar( TRect r )
{
    r.b.y = r.a.y + 1;

   TMenuItem *two =
      new TMenuItem("~E~xit", cmQuit, kbAltX);

   TMenuItem *one =
      new TMenuItem("~\xF0~", kbAltSpace,
	new TMenu( *new TMenuItem("~T~est", cmTest, kbAltT)),
          hcNoContext, two);

    return ( new TMenuBar( r, new TMenu( *one ) )  );

}


int main()
{

  TMyApp *myApp = new TMyApp();
  myApp->run();
  return 0;
}
