/* ------------------------------------------------------------------------*/
/*                                                                         */
/*   RANGELIN.HPP                                                          */
/*                                                                         */
/*   Copyright (c) Borland International 1991                              */
/*   All Rights Reserved.                                                  */
/*                                                                         */
/*   defines the class RangeLine                                           */
/*                                                                         */
/* ------------------------------------------------------------------------*/

#ifndef __RANGELINE_
#define __RANGELINE_

#define Uses_TInputLine
#define Uses_TEvent
#include <tv.h>

//  Input Flags masks
const ushort
    ifUpper         = 0x001,      //allow uppercase characters
    ifLower         = 0x002,      //allow owercase characters
    ifNum           = 0x004,      //allow digits
    ifSpace         = 0x008,      //allow spaces
    ifRange         = 0x010,      //a range of values will follow
    ifDefault       = 0x020;      //allow all printable chars


class RangeLine : public TInputLine
{
   short inputFlags;
   short begin, end;

   public:
    RangeLine(const TRect& bounds, int aMaxLen, ushort iMask, short from = 0, short to =0):
    TInputLine( bounds, aMaxLen )
    {
       inputFlags = iMask;
       begin = from;
       end   = to;
    }
   protected:
    virtual void handleEvent( TEvent& event );

};

#endif  //_RANGELINE_
