/* ------------------------------------------------------------------------*/
/*                                                                         */
/*   RANGELIN.CPP                                                          */
/*                                                                         */
/*   Copyright (c) Borland International 1991                              */
/*   All Rights Reserved.                                                  */
/*                                                                         */
/*   class RangeLine                                                       */
/*                                                                         */
/* ------------------------------------------------------------------------*/

#include "rangelin.hpp"
#include <stdio.h>       //putchar
#include <ctype.h>       //isalpha, isdigit ...
#include <string.h>      //strncpy


void RangeLine::handleEvent(TEvent& event )
{
    static char beep = '\a';
    if( isprint(event.keyDown.charScan.charCode) )
    {
      if( ifDefault & inputFlags ||
        (ifUpper & inputFlags && isupper(event.keyDown.charScan.charCode))||
        (ifLower & inputFlags && islower(event.keyDown.charScan.charCode))||
        (ifNum   & inputFlags && isdigit(event.keyDown.charScan.charCode))||
        (ifSpace & inputFlags && isspace(event.keyDown.charScan.charCode)) )
        {
          if( ifRange & inputFlags )
            if( (event.keyDown.charScan.charCode < begin) ||
              (event.keyDown.charScan.charCode > end) )
            {
               putchar(beep);
               clearEvent(event);
               return;
            }

         }
         else
         {
            putchar(beep);
            clearEvent(event);
            return;
         }

    }

    TInputLine::handleEvent( event );

}



