#include <alloc.h>
#include <string.h>
#include <conio.h>
#define OK 1
#define ON 1
#define OFF 0

// constant border characters
const int borderchar[9][6]={{0,  0,  0,  0,  0,  0  },
			    {218,191,192,217,196,179},
			    {201,187,200,188,205,186},
			    {213,184,212,190,205,179},
			    {214,183,211,189,196,186},
			    {176,176,176,176,176,176},
			    {177,177,177,177,177,177},
			    {178,178,178,178,178,178},
			    {219,219,219,219,219,219}};

class Box
   {
   private:

      // box configuration parameters
      int upperleftx, upperlefty, boxwidth, boxheight;
      int border, shadowflag;
      int fgcolor, bgcolor;
      char *title, *tbuffer;

      // utility variables
      int xlimit, ylimit;

   public:

      Box()     // constructor with no args.
	 {
	 upperleftx=1; upperlefty=1; boxwidth=80; boxheight=25;
	 border=0; shadowflag=OFF; fgcolor=15; bgcolor=0;
	 title="";
	 xlimit=80; ylimit=25;
	 }

      Box(int ulx, int uly, int bw, int bh)     // constructor w/ size args.
	 {
	 upperleftx=ulx; upperlefty=uly; boxwidth=bw; boxheight=bh;
	 border=0; shadowflag=OFF; fgcolor=15; bgcolor=0;
	 title="";
	 xlimit=80; ylimit=25;
	 }

      void setsize(int ulx, int uly, int bw, int bh)
	 {
	 upperleftx=ulx; upperlefty=uly; boxwidth=bw; boxheight=bh;
	 }

      void setcolor(int fgc, int bgc)
	 {
	 fgcolor=fgc; bgcolor=bgc;
	 }

      void setborder(int bdr)
	 {
	 border=bdr;
	 }

      void setshadowflag(int sw)
	 {
	 if (sw > 0)
	    {
	    shadowflag=sw;
	    xlimit=79; ylimit=24;
	    }
	 }

      void settitle(char *txt)
	 {
	 title=txt;
	 }

      void activate()
	 {
	 window(upperleftx+1,upperlefty+1,upperleftx+boxwidth-2,
	 upperlefty+boxheight-2);
	 textbackground(bgcolor);
	 textcolor(fgcolor);
	 }

      int draw();
      int savetext();
      int restoretext();

   };

int Box::draw()
   {
   struct text_info t_info;

   // determine if dimensional error exists, return -1 if so.
   if ((upperleftx+boxwidth-1>xlimit) || (upperlefty+boxheight-1>ylimit)
   || (upperleftx<0) || (upperlefty<0))
      {
      return -1;
      }

   // determine whether or not to draw shadow and do so.
   if (shadowflag>0)
      {
      window(upperleftx+1, upperlefty+1,
      upperleftx+boxwidth, upperlefty+boxheight);
      textbackground(BLACK);
      clrscr();
      }

   // draw the actual window and clear ir with bgcolor.
   window(upperleftx,upperlefty,upperleftx+boxwidth-1,
   upperlefty+boxheight-1);
   textbackground(bgcolor);
   clrscr();

   // take off scroll feature.
   _wscroll=OFF;

   // check if border is valid and if so,
   // draw the appropriate border chars.
   if ( ( border < 0 ) || ( border > 8 ) )
      {
      return -2;
      }
   window(1,1,80,25);
   textcolor(fgcolor);
   gotoxy(upperleftx,upperlefty);
   cprintf("%c", borderchar[border][0]);
   gotoxy(upperleftx+boxwidth-1,upperlefty);
   cprintf("%c", borderchar[border][1]);
   gotoxy(upperleftx+boxwidth-1,upperlefty+boxheight-1);
   cprintf("%c", borderchar[border][3]);
   gotoxy(upperleftx,upperlefty+boxheight-1);
   cprintf("%c", borderchar[border][2]);
   for (int pos = upperleftx + 1; pos<upperleftx + boxwidth-1; pos++)
      {
      gotoxy(pos,upperlefty);
      cprintf("%c", borderchar[border][4]);
      gotoxy(pos, upperlefty + boxheight -1 );
      cprintf("%c", borderchar[border][4]);
      }
   for (pos = upperlefty + 1; pos < upperlefty + boxheight -1; pos++)
      {
      gotoxy(upperleftx, pos);
      cprintf("%c", borderchar[border][5]);
      gotoxy(upperleftx + boxwidth-1, pos);
      cprintf("%c", borderchar[border][5]);
      }

   // get back into the window
   window(upperleftx, upperlefty, upperleftx + boxwidth-1,
   upperlefty + boxheight-1);

   // get the window info, determine if title is small enough to fit,
   // if so, print it on the top line.
   gettextinfo(&t_info);
   if(strlen(title) > t_info.winright - t_info.winleft)
      {
      return -3;
      }
   gotoxy((t_info.winright-t_info.winleft)/2-strlen(title)/2+1,1);
   cputs(title);

   // resize window inside border, turn scroll on, and exit.
   window(upperleftx+1,upperlefty+1,upperleftx+boxwidth-2,
   upperlefty+boxheight-2);
   _wscroll=ON;
   return OK;
      }
int Box::savetext()
   {
   int bufsize;
   if (shadowflag<1)
      {
      bufsize = 2*((upperlefty+boxheight)-upperlefty+1)*((upperleftx+boxwidth)-upperleftx+1);
      if((tbuffer=(char*)malloc(bufsize))==NULL)
	 {
	 return -1;
	 }
      if(!gettext(upperleftx,upperlefty,upperleftx+boxwidth-1,upperlefty+boxheight-1,tbuffer))
	 {
	 return -2;
	 }
      }
   else
      if(shadowflag>0)
	 {
	 bufsize = 2*((upperlefty+boxheight)-upperlefty+2)*((upperleftx+boxwidth)-upperleftx+2);
	 if((tbuffer=(char*)malloc(bufsize))==NULL)
	    {
	    return -1;
	    }
	 if(!gettext(upperleftx,upperlefty,upperleftx+boxwidth,upperlefty+boxheight,tbuffer))
	    {
	    return -2;
	    }
	 }
   }

int Box::restoretext()
   {
   if (shadowflag<1)
      {
      if(!puttext(upperleftx,upperlefty,upperleftx+boxwidth-1,upperlefty+boxheight-1,tbuffer))
	 {
	 return -1;
	 }
      }
   else
      if(shadowflag>0)
	 {
	 if(!puttext(upperleftx,upperlefty,upperleftx+boxwidth,upperlefty+boxheight,tbuffer))
	    {
	    return -1;
	    }
	 }
   }






